/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.commands;

import com.majruszs_difficulty.RegistryHandler;
import com.majruszs_difficulty.features.undead_army.UndeadArmy;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class UndeadArmyManagerCommand {
    private UndeadArmyManagerCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"undead_army").requires(source -> source.func_197034_c(4))).then(Commands.func_197057_a((String)"stop").executes(entity -> UndeadArmyManagerCommand.stopUndeadArmy((CommandSource)entity.getSource())))).then(Commands.func_197057_a((String)"highlight").executes(entity -> UndeadArmyManagerCommand.highlightUndeadArmy((CommandSource)entity.getSource())))).then(Commands.func_197057_a((String)"undead_left").executes(entity -> UndeadArmyManagerCommand.countUndeadLeft((CommandSource)entity.getSource())))).then(Commands.func_197057_a((String)"kill_all").executes(entity -> UndeadArmyManagerCommand.killUndeadArmy((CommandSource)entity.getSource()))));
    }

    public static int stopUndeadArmy(CommandSource source) {
        UndeadArmy undeadArmy = RegistryHandler.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(new BlockPos(source.func_197036_d()));
        if (undeadArmy == null) {
            source.func_197030_a((ITextComponent)UndeadArmyManagerCommand.getMissingUndeadArmyFeedback(), true);
            return -1;
        }
        undeadArmy.finish();
        return 0;
    }

    public static int highlightUndeadArmy(CommandSource source) {
        UndeadArmy undeadArmy = RegistryHandler.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(new BlockPos(source.func_197036_d()));
        if (undeadArmy == null) {
            source.func_197030_a((ITextComponent)UndeadArmyManagerCommand.getMissingUndeadArmyFeedback(), true);
            return -1;
        }
        undeadArmy.highlightUndeadArmy();
        return 0;
    }

    public static int countUndeadLeft(CommandSource source) {
        UndeadArmy undeadArmy = RegistryHandler.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(new BlockPos(source.func_197036_d()));
        if (undeadArmy == null) {
            source.func_197030_a((ITextComponent)UndeadArmyManagerCommand.getMissingUndeadArmyFeedback(), true);
            return -1;
        }
        TranslationTextComponent feedback = new TranslationTextComponent("commands.undead_army.undead_left");
        feedback.func_240702_b_(" " + undeadArmy.countUndeadEntitiesLeft() + ".");
        source.func_197030_a((ITextComponent)feedback, true);
        return 0;
    }

    public static int killUndeadArmy(CommandSource source) {
        UndeadArmy undeadArmy = RegistryHandler.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(new BlockPos(source.func_197036_d()));
        if (undeadArmy == null) {
            source.func_197030_a((ITextComponent)UndeadArmyManagerCommand.getMissingUndeadArmyFeedback(), true);
            return -1;
        }
        undeadArmy.killAllUndeadArmyEntities();
        return 0;
    }

    private static IFormattableTextComponent getMissingUndeadArmyFeedback() {
        return new TranslationTextComponent("commands.undead_army.missing");
    }
}

