/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.effects;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.config.GameStateIntegerConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.StringListConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BleedingEffect
extends Effect {
    private static final String BLEEDING_TAG_COUNTER = "BleedingCounter";
    protected final ConfigGroup bleedingGroup;
    protected final DoubleConfig damage;
    protected final DurationConfig baseCooldown;
    protected final DoubleConfig armorChanceReduction;
    protected final GameStateIntegerConfig amplifier;
    protected final StringListConfig entitiesBlackList;

    public BleedingEffect() {
        super(EffectType.HARMFUL, -2271915);
        String damageComment = "Damage dealt by bleeding every tick.";
        String cooldownComment = "Cooldown between attacking entity.";
        String armorComment = "Bleeding chance reduction per armor piece.";
        String amplifierComment = "Bleeding amplifier.";
        String blackComment = "List of entities that are immune to Bleeding effect. (only human-like mobs and animals)";
        this.damage = new DoubleConfig("damage", damageComment, false, 1.0, 0.0, 20.0);
        this.baseCooldown = new DurationConfig("cooldown", cooldownComment, false, 4.0, 0.0, 20.0);
        this.armorChanceReduction = new DoubleConfig("armor_reduction", armorComment, false, 0.2, 0.0, 0.25);
        this.amplifier = new GameStateIntegerConfig("amplifier", amplifierComment, 0, 1, 2, 0, 10);
        this.entitiesBlackList = new StringListConfig("black_list", blackComment, false, new String[]{"minecraft:skeleton_horse"});
        this.bleedingGroup = (ConfigGroup)MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)new ConfigGroup("Bleeding", "Bleeding potion effect."));
        this.bleedingGroup.addConfigs(new IConfig[]{this.damage, this.baseCooldown, this.armorChanceReduction, this.amplifier, this.entitiesBlackList});
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        double damageAmount = this.damage.get();
        if (entity.func_70660_b((Effect)Instances.BLEEDING) instanceof BleedingEffectInstance) {
            BleedingEffectInstance bleedingEffectInstance = (BleedingEffectInstance)entity.func_70660_b((Effect)Instances.BLEEDING);
            Vector3d motion = entity.func_213322_ci();
            entity.func_70097_a((DamageSource)(bleedingEffectInstance != null ? new EntityBleedingDamageSource(bleedingEffectInstance.damageSourceEntity) : Instances.BLEEDING_SOURCE), (float)damageAmount);
            entity.func_213317_d(motion);
        } else {
            entity.func_70097_a(Instances.BLEEDING_SOURCE, (float)damageAmount);
        }
    }

    public void func_180793_a(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
    }

    public boolean func_76397_a(int duration, int amplifier) {
        int cooldown = Math.max(4, this.baseCooldown.getDuration() >> amplifier);
        return duration % cooldown == 0;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    @SubscribeEvent
    public static void spawnParticles(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (!(player.field_70170_p instanceof ServerWorld) || !(player instanceof ServerPlayerEntity)) {
            return;
        }
        CompoundNBT data = player.getPersistentData();
        data.func_74768_a(BLEEDING_TAG_COUNTER, (data.func_74762_e(BLEEDING_TAG_COUNTER) + 1) % 5);
        ServerWorld world = (ServerWorld)player.field_70170_p;
        if (player.func_70644_a((Effect)Instances.BLEEDING) && data.func_74762_e(BLEEDING_TAG_COUNTER) == 0) {
            world.func_195598_a((IParticleData)Instances.BLOOD_PARTICLE, player.func_226277_ct_(), player.func_226283_e_(0.5), player.func_226281_cx_(), 1, 0.125, 0.5, 0.125, 0.1);
        }
    }

    public int getAmplifier() {
        return this.amplifier.getCurrentGameStateValue();
    }

    public boolean mayBleed(@Nullable Entity entity) {
        return (MajruszsHelper.isAnimal(entity) || MajruszsHelper.isHuman(entity)) && !this.isBlackListed(entity);
    }

    private boolean isBlackListed(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        EntityType entityType = entity.func_200600_R();
        ResourceLocation entityLocation = entityType.getRegistryName();
        return entityLocation != null && this.entitiesBlackList.contains(entityLocation.toString());
    }

    public double getChanceMultiplierDependingOnArmor(LivingEntity entity) {
        double chance = 1.0;
        for (ItemStack armorPiece : entity.func_184193_aE()) {
            if (armorPiece.func_190926_b()) continue;
            chance -= this.armorChanceReduction.get().doubleValue();
        }
        return chance;
    }

    public static class BleedingEffectInstance
    extends EffectInstance {
        @Nullable
        protected final Entity damageSourceEntity;

        public BleedingEffectInstance(int duration, int amplifier, boolean ambient, boolean showParticles, @Nullable LivingEntity attacker) {
            super((Effect)Instances.BLEEDING, duration, amplifier, ambient, showParticles);
            this.damageSourceEntity = attacker;
        }
    }

    public static class EntityBleedingDamageSource
    extends DamageSource {
        @Nullable
        protected final Entity damageSourceEntity;

        public EntityBleedingDamageSource(@Nullable Entity damageSourceEntity) {
            super(Instances.BLEEDING_SOURCE.field_76373_n);
            this.func_76348_h();
            this.damageSourceEntity = damageSourceEntity;
        }

        @Nullable
        public Entity func_76346_g() {
            return this.damageSourceEntity;
        }
    }
}

