/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.entities;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.entities.EntitiesConfig;
import com.mlib.MajruszLibrary;
import com.mlib.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EliteSkeletonEntity
extends SkeletonEntity {
    public static final Potion[] arrowPotions = new Potion[]{Potions.field_185252_x, Potions.field_185254_z, Potions.field_185246_r, Potions.field_185226_I};
    public static final EntityType<EliteSkeletonEntity> type = EntityType.Builder.func_220322_a(EliteSkeletonEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 2.0f).func_206830_a(MajruszsDifficulty.getLocation("elite_skeleton").toString());
    private static final float ARROW_VELOCITY = 2.0f;
    private static final float ARROW_INACCURACY = 0.0f;
    private int quickShotsLeft = 0;

    public EliteSkeletonEntity(EntityType<? extends SkeletonEntity> type, World world) {
        super(type, world);
        this.field_85037_d = new RangedBowAttackGoal((MonsterEntity)this, 0.8333333333333334, this.getAttackCooldown(), 20.0f);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        EntitiesConfig.EliteSkeletonConfig config = Instances.ENTITIES_CONFIG.eliteSkeleton;
        double clampedRegionalDifficulty = GameState.getRegionalDifficulty((LivingEntity)this);
        this.handleQuickShot(config.quickShotChance.get() * clampedRegionalDifficulty);
        this.handleExtraArrows(config.multiShotChance.get() * clampedRegionalDifficulty, target, distanceFactor);
        this.spawnArrow(0.0, target, distanceFactor);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (MajruszLibrary.RANDOM.nextFloat() * 0.4f + 0.8f));
    }

    public static AttributeModifierMap getAttributeMap() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 2.5).func_233813_a_();
    }

    protected void spawnArrow(double yFactor, LivingEntity target, float distanceFactor) {
        ItemStack heldItemStack = this.func_184614_ca();
        AbstractArrowEntity arrowEntity = this.getArrowEntity(distanceFactor);
        if (heldItemStack.func_77973_b() instanceof BowItem) {
            arrowEntity = ((BowItem)heldItemStack.func_77973_b()).customArrow(arrowEntity);
        }
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.2) - arrowEntity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        arrowEntity.func_70186_c(d0, d1 + d3 * 0.2 + yFactor, d2, 2.0f, 0.0f);
        this.field_70170_p.func_217376_c((Entity)arrowEntity);
    }

    protected AbstractArrowEntity getArrowEntity(float distanceFactor) {
        ItemStack ammunition = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        double tippedArrowChance = Instances.ENTITIES_CONFIG.eliteSkeleton.tippedArrowChance.get() * GameState.getRegionalDifficulty((LivingEntity)this);
        if (Random.tryChance((double)tippedArrowChance) && ammunition.func_77973_b() instanceof ArrowItem) {
            ammunition = new ItemStack((IItemProvider)Items.field_185167_i);
            PotionUtils.func_185188_a((ItemStack)ammunition, (Potion)arrowPotions[MajruszLibrary.RANDOM.nextInt(arrowPotions.length)]);
        }
        return this.func_213624_b(ammunition, distanceFactor);
    }

    protected int getAttackCooldown() {
        return this.field_70170_p.func_175659_aa() != Difficulty.HARD ? 40 : 20;
    }

    protected void handleQuickShot(double quickShotChance) {
        if (this.quickShotsLeft == 0 && Random.tryChance((double)quickShotChance) && this.field_70170_p instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197609_b, this.func_226277_ct_(), this.func_226283_e_(0.5), this.func_226281_cx_(), 6, 0.5, 0.25, 0.5, 0.125);
            this.quickShotsLeft = 3;
            this.field_85037_d.func_189428_b(1);
        } else if (this.quickShotsLeft > 0 && --this.quickShotsLeft == 0) {
            this.field_85037_d.func_189428_b(this.getAttackCooldown());
        }
    }

    protected void handleExtraArrows(double multiShotChance, LivingEntity target, float distanceFactor) {
        if (this.quickShotsLeft == 0 && Random.tryChance((double)multiShotChance)) {
            this.spawnArrow(1.25, target, distanceFactor);
            this.spawnArrow(-1.25, target, distanceFactor);
        }
    }
}

