/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.entities.EliteSkeletonEntity;
import com.majruszs_difficulty.entities.GiantEntity;
import com.majruszs_difficulty.generation.OreGeneration;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BiomeLoading {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLoad(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        MobSpawnInfoBuilder spawnInfoBuilder = event.getSpawns();
        BiomeGenerationSettingsBuilder generationSettingsBuilder = event.getGeneration();
        if (BiomeLoading.doBiomeCategoryBelongsToOverworld(category)) {
            BiomeLoading.addOverworldEntities(spawnInfoBuilder);
            BiomeLoading.addOverworldStructures(generationSettingsBuilder);
        } else if (BiomeLoading.doBiomeCategoryBelongsToNether(category)) {
            BiomeLoading.addNetherEntities(spawnInfoBuilder);
        } else if (BiomeLoading.doBiomeCategoryBelongsToTheEnd(category)) {
            BiomeLoading.addEndStructures(generationSettingsBuilder);
            BiomeLoading.addEndOres(generationSettingsBuilder);
        }
    }

    protected static void addOverworldEntities(MobSpawnInfoBuilder spawnInfoBuilder) {
        BiomeLoading.addEntity(spawnInfoBuilder, EntityClassification.MONSTER, EntityType.field_200764_D, 20, 1, 2);
        BiomeLoading.addEntity(spawnInfoBuilder, EntityClassification.MONSTER, GiantEntity.type, 3, 1, 1);
        BiomeLoading.addEntity(spawnInfoBuilder, EntityClassification.MONSTER, EliteSkeletonEntity.type, 20, 1, 1);
    }

    protected static void addOverworldStructures(BiomeGenerationSettingsBuilder generationSettingsBuilder) {
    }

    protected static void addNetherEntities(MobSpawnInfoBuilder spawnInfoBuilder) {
        Set entityTypes = spawnInfoBuilder.getEntityTypes();
        if (entityTypes.contains(EntityType.field_200741_ag) || entityTypes.contains(EntityType.field_200722_aA)) {
            BiomeLoading.addEntity(spawnInfoBuilder, EntityClassification.MONSTER, EliteSkeletonEntity.type, 5, 1, 1);
        }
    }

    protected static void addEndStructures(BiomeGenerationSettingsBuilder generationSettingsBuilder) {
        generationSettingsBuilder.func_242516_a(Instances.FLYING_PHANTOM_FEATURE);
        generationSettingsBuilder.func_242516_a(Instances.FLYING_END_ISLAND_FEATURE);
        generationSettingsBuilder.func_242516_a(Instances.FLYING_END_SHIP_FEATURE);
    }

    protected static void addEndOres(BiomeGenerationSettingsBuilder generationSettingsBuilder) {
        for (ConfiguredFeature<?, ?> ore : OreGeneration.END_ORES) {
            generationSettingsBuilder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ore);
        }
    }

    protected static boolean doBiomeCategoryBelongsToOverworld(Biome.Category category) {
        boolean isTaiga = category == Biome.Category.TAIGA;
        boolean isExtremeHills = category == Biome.Category.EXTREME_HILLS;
        boolean isJungle = category == Biome.Category.JUNGLE;
        boolean isMesa = category == Biome.Category.MESA;
        boolean isPlains = category == Biome.Category.PLAINS;
        boolean isSavanna = category == Biome.Category.SAVANNA;
        boolean isIcy = category == Biome.Category.ICY;
        boolean isBeach = category == Biome.Category.BEACH;
        boolean isForest = category == Biome.Category.FOREST;
        boolean isOcean = category == Biome.Category.OCEAN;
        boolean isDesert = category == Biome.Category.DESERT;
        boolean isRiver = category == Biome.Category.RIVER;
        boolean isSwamp = category == Biome.Category.SWAMP;
        boolean isMushroom = category == Biome.Category.MUSHROOM;
        return isTaiga || isExtremeHills || isJungle || isMesa || isPlains || isSavanna || isIcy || isBeach || isForest || isOcean || isDesert || isRiver || isSwamp || isMushroom;
    }

    protected static boolean doBiomeCategoryBelongsToNether(Biome.Category category) {
        return category == Biome.Category.NETHER;
    }

    protected static boolean doBiomeCategoryBelongsToTheEnd(Biome.Category category) {
        return category == Biome.Category.THEEND;
    }

    private static void addEntity(MobSpawnInfoBuilder spawnInfoBuilder, EntityClassification classification, EntityType<?> entityType, int weight, int minimumCount, int maximumCount) {
        MobSpawnInfo.Spawners spawners = new MobSpawnInfo.Spawners(entityType, weight, minimumCount, maximumCount);
        spawnInfoBuilder.func_242575_a(classification, spawners);
    }
}

