/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.FeatureBase;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;

public abstract class ChanceFeatureBase
extends FeatureBase {
    protected final boolean shouldChanceBeMultipliedByCRD;
    protected final DoubleConfig chance;

    public ChanceFeatureBase(String configName, String configComment, double defaultChance, GameState.State minimumState, boolean shouldChanceBeMultipliedByCRD) {
        super(configName, configComment, minimumState);
        this.shouldChanceBeMultipliedByCRD = shouldChanceBeMultipliedByCRD;
        String crd = "(this value is scaled by Clamped Regional Difficulty)";
        String chanceComment = "Chance of this feature to happen. " + (this.shouldChanceBeMultipliedByCRD ? crd : "");
        this.chance = new DoubleConfig("chance", chanceComment, false, defaultChance, 0.0, 1.0);
        this.featureGroup.addConfigs(new IConfig[]{this.chance});
    }

    public double getChance() {
        return this.chance.get();
    }

    public double calculateChance(@Nullable LivingEntity target) {
        double clampedRegionalDifficulty = target != null ? GameState.getRegionalDifficulty(target) : 0.25;
        return this.getChance() * (this.shouldChanceBeMultipliedByCRD ? clampedRegionalDifficulty : 1.0);
    }

    public boolean tryChance(@Nullable LivingEntity target) {
        return Random.tryChance((double)this.calculateChance(target));
    }
}

