/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.features.monster_spawn.OnEnemyToBeSpawnedBase;
import com.mlib.TimeConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnEnemyToBeSpawnedEvent {
    public static final List<OnEnemyToBeSpawnedBase> REGISTRY_LIST = new ArrayList<OnEnemyToBeSpawnedBase>();
    private static final String MARK_TAG = "MajruszDifficultyEntityMarked";
    private static final int cooldown = TimeConverter.secondsToTicks((double)10.0);
    private static int counter = 0;

    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.SpecialSpawn event) {
        LivingEntity entity = event.getEntityLiving();
        OnEnemyToBeSpawnedEvent.markEntity((Entity)entity);
        for (OnEnemyToBeSpawnedBase register : REGISTRY_LIST) {
            if (!register.shouldBeExecuted(entity)) continue;
            register.onExecute(entity, (ServerWorld)entity.field_70170_p);
            if (!register.shouldSpawnBeCancelled()) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (!(event.world instanceof ServerWorld) || event.phase == TickEvent.Phase.START) {
            return;
        }
        ServerWorld world = (ServerWorld)event.world;
        if (++counter % cooldown != 0) {
            return;
        }
        Stream entities = world.getEntities();
        entities.forEach(entity -> {
            if (entity instanceof LivingEntity && !OnEnemyToBeSpawnedEvent.isMarked(entity)) {
                LivingEntity livingEntity = (LivingEntity)entity;
                OnEnemyToBeSpawnedEvent.markEntity((Entity)livingEntity);
                for (OnEnemyToBeSpawnedBase register : REGISTRY_LIST) {
                    if (!register.shouldBeExecuted(livingEntity)) continue;
                    register.onExecute(livingEntity, world);
                }
            }
        });
    }

    private static void markEntity(Entity entity) {
        CompoundNBT data = entity.getPersistentData();
        data.func_74757_a(MARK_TAG, true);
    }

    private static boolean isMarked(Entity entity) {
        CompoundNBT data = entity.getPersistentData();
        return data.func_74764_b(MARK_TAG) && data.func_74767_n(MARK_TAG);
    }
}

