/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.monster_spawn.OnEnemyToBeSpawnedBase;
import com.majruszs_difficulty.goals.FollowGroupLeaderGoal;
import com.majruszs_difficulty.goals.TargetAsLeaderGoal;
import com.mlib.MajruszLibrary;
import com.mlib.items.ItemHelper;
import java.util.ArrayList;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public abstract class SpawnEnemyGroupBase
extends OnEnemyToBeSpawnedBase {
    protected final int minimumAmountOfChildren;
    protected final int maximumAmountOfChildren;
    protected final Item[] leaderArmor;
    private static final String SIDEKICK_TAG = "MajruszsDifficultySidekick";

    public SpawnEnemyGroupBase(String configName, String configComment, GameState.State minimumState, boolean shouldChanceBeMultipliedByCRD, int minimumAmountOfChildren, int maximumAmountOfChildren, Item[] leaderArmor) {
        super(configName, configComment, 0.25, minimumState, shouldChanceBeMultipliedByCRD);
        this.minimumAmountOfChildren = minimumAmountOfChildren;
        this.maximumAmountOfChildren = maximumAmountOfChildren;
        this.leaderArmor = leaderArmor;
    }

    @Override
    public void onExecute(LivingEntity entity, ServerWorld world) {
        int childrenAmount = this.minimumAmountOfChildren + MajruszLibrary.RANDOM.nextInt(this.maximumAmountOfChildren - this.minimumAmountOfChildren + 1);
        if (this.isSidekick(entity)) {
            return;
        }
        if (this.leaderArmor != null) {
            this.giveArmorToLeader(entity);
        }
        this.spawnChildren(childrenAmount, entity, world);
    }

    protected abstract CreatureEntity spawnChild(ServerWorld var1);

    protected ItemStack generateWeaponForChild() {
        return null;
    }

    protected void markAsSidekick(LivingEntity entity) {
        CompoundNBT data = entity.getPersistentData();
        data.func_74757_a(SIDEKICK_TAG, true);
    }

    protected boolean isSidekick(LivingEntity entity) {
        CompoundNBT data = entity.getPersistentData();
        return data.func_74764_b(SIDEKICK_TAG) && data.func_74767_n(SIDEKICK_TAG);
    }

    private void giveArmorToLeader(LivingEntity leader) {
        double clampedRegionalDifficulty = GameState.getRegionalDifficulty(leader);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Item item : this.leaderArmor) {
            itemStacks.add(ItemHelper.damageAndEnchantItem((ItemStack)new ItemStack((IItemProvider)item), (double)clampedRegionalDifficulty, (boolean)true, (double)0.5));
        }
        leader.func_184201_a(EquipmentSlotType.FEET, (ItemStack)itemStacks.get(0));
        leader.func_184201_a(EquipmentSlotType.LEGS, (ItemStack)itemStacks.get(1));
        leader.func_184201_a(EquipmentSlotType.CHEST, (ItemStack)itemStacks.get(2));
        leader.func_184201_a(EquipmentSlotType.HEAD, (ItemStack)itemStacks.get(3));
    }

    private void giveWeaponTo(LivingEntity child) {
        double clampedRegionalDifficulty = GameState.getRegionalDifficulty(child);
        ItemStack weapon = this.generateWeaponForChild();
        if (weapon != null) {
            child.func_184201_a(EquipmentSlotType.MAINHAND, ItemHelper.damageAndEnchantItem((ItemStack)weapon, (double)clampedRegionalDifficulty, (boolean)true, (double)0.5));
        }
    }

    private void setupGoals(CreatureEntity leader, CreatureEntity follower, int goalPriority, int targetPriority) {
        follower.field_70714_bg.func_75776_a(goalPriority, (Goal)new FollowGroupLeaderGoal((MobEntity)follower, (MobEntity)leader, 1.0, 6.0f, 5.0f));
        follower.field_70715_bh.func_75776_a(targetPriority, (Goal)new TargetAsLeaderGoal(follower, leader));
    }

    private void spawnChildren(int amount, LivingEntity leader, ServerWorld world) {
        Vector3d spawnPosition = leader.func_213303_ch();
        if (!(leader instanceof CreatureEntity)) {
            return;
        }
        for (int childID = 0; childID < amount; ++childID) {
            CreatureEntity child = this.spawnChild(world);
            double x = spawnPosition.field_72450_a - 3.0 + (double)MajruszLibrary.RANDOM.nextInt(7);
            double y = spawnPosition.field_72448_b + 0.5;
            double z = spawnPosition.field_72449_c - 3.0 + (double)MajruszLibrary.RANDOM.nextInt(7);
            child.func_70107_b(x, y, z);
            this.setupGoals((CreatureEntity)leader, child, 9, 9);
            this.giveWeaponTo((LivingEntity)child);
            this.markAsSidekick((LivingEntity)child);
            world.func_217470_d((Entity)child);
        }
    }

    protected static class Armors {
        public static Item[] leather = new Item[]{Items.field_151021_T, Items.field_151026_S, Items.field_151027_R, Items.field_151024_Q};
        public static Item[] iron = new Item[]{Items.field_151167_ab, Items.field_151165_aa, Items.field_151030_Z, Items.field_151028_Y};
        public static Item[] golden = new Item[]{Items.field_151151_aj, Items.field_151149_ai, Items.field_151171_ah, Items.field_151169_ag};

        protected Armors() {
        }
    }
}

