/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.monster_spawn;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.entities.EliteSkeletonEntity;
import com.majruszs_difficulty.features.monster_spawn.SpawnEnemyGroupBase;
import com.mlib.MajruszLibrary;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpawnSkeletonGroup
extends SpawnEnemyGroupBase {
    private static final String CONFIG_NAME = "SkeletonGroup";
    private static final String CONFIG_COMMENT = "Skeleton spawns in groups.";
    protected final DoubleConfig woodenSwordChance;
    protected final DoubleConfig stoneSwordChance;

    public SpawnSkeletonGroup() {
        super(CONFIG_NAME, CONFIG_COMMENT, GameState.State.EXPERT, true, 1, 3, SpawnEnemyGroupBase.Armors.leather);
        String wooden_comment = "Chance for followers to have a Wooden Sword.";
        String stone_comment = "Chance for followers to have a Stone Sword.";
        this.woodenSwordChance = new DoubleConfig("wooden_sword_chance", wooden_comment, false, 0.5, 0.0, 0.5);
        this.stoneSwordChance = new DoubleConfig("stone_sword_chance", stone_comment, false, 0.25, 0.0, 0.5);
        this.featureGroup.addConfigs(new IConfig[]{this.woodenSwordChance, this.stoneSwordChance});
    }

    @Override
    public boolean shouldBeExecuted(LivingEntity entity) {
        return entity instanceof SkeletonEntity && !(entity instanceof EliteSkeletonEntity) && super.shouldBeExecuted(entity);
    }

    @Override
    protected CreatureEntity spawnChild(ServerWorld world) {
        return (CreatureEntity)EntityType.field_200741_ag.func_200721_a((World)world);
    }

    @Override
    protected ItemStack generateWeaponForChild() {
        double itemChance = MajruszLibrary.RANDOM.nextDouble();
        if (itemChance <= this.woodenSwordChance.get()) {
            return new ItemStack((IItemProvider)Items.field_151041_m);
        }
        if (itemChance <= this.woodenSwordChance.get() + this.stoneSwordChance.get()) {
            return new ItemStack((IItemProvider)Items.field_151052_q);
        }
        return null;
    }
}

