/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.treasure_bag;

import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.features.treasure_bag.TreasureBagManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class UpdatePlayerList {
    @SubscribeEvent
    public static void onHit(LivingHurtEvent event) {
        PlayerEntity player = MajruszsHelper.getPlayerFromDamageSource(event.getSource());
        LivingEntity target = event.getEntityLiving();
        if (player == null || !TreasureBagManager.hasTreasureBag(target.func_200600_R())) {
            return;
        }
        ListNBT listNBT = UpdatePlayerList.getOrCreateList(target);
        CompoundNBT playerNBT = UpdatePlayerList.getPlayerCompound(player);
        if (!UpdatePlayerList.isPlayerInList(player, listNBT)) {
            listNBT.add((Object)playerNBT);
        }
        CompoundNBT data = target.getPersistentData();
        data.func_218657_a("TreasureBagPlayersToReward", (INBT)listNBT);
    }

    protected static ListNBT getOrCreateList(LivingEntity entity) {
        CompoundNBT data = entity.getPersistentData();
        return data.func_74764_b("TreasureBagPlayersToReward") ? data.func_150295_c("TreasureBagPlayersToReward", 10) : new ListNBT();
    }

    protected static String getPlayerUUID(PlayerEntity player) {
        return String.valueOf(player.func_110124_au());
    }

    protected static CompoundNBT getPlayerCompound(PlayerEntity player) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("TreasureBagPlayerUUID", UpdatePlayerList.getPlayerUUID(player));
        return nbt;
    }

    protected static boolean isPlayerInList(PlayerEntity player, ListNBT listNBT) {
        String uuid = UpdatePlayerList.getPlayerUUID(player);
        for (int i = 0; i < listNBT.size(); ++i) {
            if (!listNBT.func_150305_b(i).func_74779_i("TreasureBagPlayerUUID").equals(uuid)) continue;
            return true;
        }
        return false;
    }
}

