/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.mlib.MajruszLibrary;
import com.mlib.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public enum Direction {
    WEST(-1, 0),
    EAST(1, 0),
    NORTH(0, -1),
    SOUTH(0, 1);

    private static final int DISTANCE_MULTIPLIER = 10;
    public final int x;
    public final int z;
    private final int xFactor;
    private final int zFactor;

    private Direction(int x, int z) {
        this.x = x;
        this.z = z;
        this.xFactor = (this.z != 0 ? 5 : 1) * 10;
        this.zFactor = (this.x != 0 ? 5 : 1) * 10;
    }

    public static Direction getRandom() {
        return Direction.values()[MajruszLibrary.RANDOM.nextInt(Direction.values().length)];
    }

    public static Direction getByName(String name) {
        for (Direction direction : Direction.values()) {
            if (!name.equalsIgnoreCase(direction.name())) continue;
            return direction;
        }
        return WEST;
    }

    public BlockPos getRandomSpawnPosition(ServerWorld world, BlockPos positionToAttack, int spawnRadius) {
        Vector3d offset = Random.getRandomVector3d((double)(-this.xFactor), (double)this.xFactor, (double)0.0, (double)0.0, (double)(-this.zFactor), (double)this.zFactor);
        int x = positionToAttack.func_177958_n() + this.x * spawnRadius + (int)offset.field_72450_a;
        int z = positionToAttack.func_177952_p() + this.z * spawnRadius + (int)offset.field_72449_c;
        int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z) + 1;
        return new BlockPos(x, y, z);
    }
}

