/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.google.common.collect.Sets;
import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.RegistryHandler;
import com.majruszs_difficulty.features.undead_army.Direction;
import com.majruszs_difficulty.features.undead_army.Status;
import com.majruszs_difficulty.features.undead_army.UndeadArmyConfig;
import com.majruszs_difficulty.features.undead_army.UndeadArmyText;
import com.majruszs_difficulty.features.undead_army.WaveMember;
import com.majruszs_difficulty.goals.UndeadAttackPositionGoal;
import com.mlib.MajruszLibrary;
import com.mlib.Random;
import com.mlib.TimeConverter;
import com.mlib.effects.EffectHelper;
import com.mlib.items.ItemHelper;
import com.mlib.nbt.NBTHelper;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class UndeadArmy {
    public static final int ARMOR_COLOR = 9595003;
    private static final int SPAWN_RADIUS = 70;
    private final ServerBossInfo bossInfo = new ServerBossInfo(UndeadArmyText.TITLE, BossInfo.Color.WHITE, BossInfo.Overlay.NOTCHED_10);
    private final BlockPos positionToAttack;
    private final Direction direction;
    private Status status;
    private boolean isActive;
    private boolean spawnerWasCreated;
    private int ticksActive;
    private int ticksInactive;
    private int ticksInactiveMaximum;
    private int ticksWaveActive;
    private int ticksBetweenWaves;
    private int ticksBetweenWavesMaximum;
    private int currentWave;
    private int undeadToKill;
    private int undeadKilled;
    private ServerWorld world;

    public UndeadArmy(ServerWorld world, BlockPos positionToAttack, Direction direction) {
        this.positionToAttack = positionToAttack;
        this.direction = direction;
        this.status = Status.BETWEEN_WAVES;
        this.isActive = true;
        this.spawnerWasCreated = false;
        this.ticksActive = 0;
        this.ticksInactive = 0;
        this.ticksWaveActive = 0;
        this.ticksBetweenWaves = 0;
        this.currentWave = 0;
        this.undeadToKill = 1;
        this.undeadKilled = 0;
        this.world = world;
        this.setConfigurationValues();
        this.bossInfo.func_186735_a(0.0f);
    }

    public UndeadArmy(ServerWorld world, CompoundNBT nbt) {
        this.positionToAttack = NBTHelper.loadBlockPos((CompoundNBT)nbt, (String)"UndeadArmyPosition");
        this.direction = Direction.getByName(nbt.func_74779_i("Direction"));
        this.status = Status.getByName(nbt.func_74779_i("Status"));
        this.isActive = nbt.func_74767_n("IsActive");
        this.spawnerWasCreated = nbt.func_74767_n("SpawnerWasCreated");
        this.ticksActive = nbt.func_74762_e("TicksActive");
        this.ticksInactive = nbt.func_74762_e("TicksInactive");
        this.ticksWaveActive = nbt.func_74762_e("TicksWaveActive");
        this.ticksBetweenWaves = nbt.func_74762_e("BetweenRaidTick");
        this.currentWave = nbt.func_74762_e("CurrentWave");
        this.undeadToKill = nbt.func_74762_e("UndeadToKill");
        this.undeadKilled = nbt.func_74762_e("UndeadKilled");
        this.world = world;
        this.setConfigurationValues();
        this.updateBarText();
    }

    public static boolean doesEntityBelongToUndeadArmy(LivingEntity entity) {
        return entity.getPersistentData().func_74764_b("UndeadArmyPositionX");
    }

    private void setConfigurationValues() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        this.ticksBetweenWaves = this.ticksBetweenWavesMaximum = config.getAmountOfTicksBetweenWaves();
        this.ticksInactiveMaximum = config.getAmountOfInactivityTicks();
    }

    public CompoundNBT write(CompoundNBT nbt) {
        NBTHelper.saveBlockPos((CompoundNBT)nbt, (String)"UndeadArmyPosition", (BlockPos)this.positionToAttack);
        nbt.func_74778_a("Direction", String.valueOf((Object)this.direction));
        nbt.func_74778_a("Status", String.valueOf((Object)this.status));
        nbt.func_74757_a("IsActive", this.isActive);
        nbt.func_74757_a("SpawnerWasCreated", this.spawnerWasCreated);
        nbt.func_74768_a("TicksActive", this.ticksActive);
        nbt.func_74768_a("TicksInactive", this.ticksInactive);
        nbt.func_74768_a("TicksWaveActive", this.ticksWaveActive);
        nbt.func_74768_a("BetweenRaidTick", this.ticksBetweenWaves);
        nbt.func_74768_a("CurrentWave", this.currentWave);
        nbt.func_74768_a("UndeadToKill", this.undeadToKill);
        nbt.func_74768_a("UndeadKilled", this.undeadKilled);
        return nbt;
    }

    public BlockPos getAttackPosition() {
        return this.positionToAttack;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void updateWorld(ServerWorld world) {
        this.world = world;
    }

    public void updateBarText() {
        switch (this.status) {
            case ONGOING: {
                this.bossInfo.func_186739_a(this.currentWave == 0 ? UndeadArmyText.TITLE : UndeadArmyText.getWaveMessage(this.currentWave));
                break;
            }
            case BETWEEN_WAVES: {
                this.bossInfo.func_186739_a(UndeadArmyText.BETWEEN_WAVES);
                break;
            }
            case VICTORY: {
                this.bossInfo.func_186739_a(UndeadArmyText.VICTORY);
                break;
            }
            case FAILED: {
                this.bossInfo.func_186739_a(UndeadArmyText.FAILED);
                break;
            }
        }
    }

    public void tick() {
        if (!this.isActive()) {
            return;
        }
        if (this.ticksActive == 0) {
            UndeadArmyText.notifyAboutStart(this.getNearbyPlayers(), this.direction);
        }
        if (this.ticksActive % 20 == 0) {
            this.updateUndeadArmyBarVisibility();
        }
        this.tickCurrentStatus();
        ++this.ticksActive;
    }

    public void tickCurrentStatus() {
        switch (this.status) {
            case BETWEEN_WAVES: {
                this.tickBetweenWaves();
                break;
            }
            case ONGOING: {
                this.tickOngoing();
                break;
            }
            case VICTORY: 
            case FAILED: {
                this.tickFinished();
                break;
            }
            case STOPPED: {
                this.tickStopped();
            }
        }
    }

    private void tickBetweenWaves() {
        --this.ticksBetweenWaves;
        this.bossInfo.func_186735_a(MathHelper.func_76131_a((float)(1.0f - (float)this.ticksBetweenWaves / (float)this.ticksBetweenWavesMaximum), (float)0.0f, (float)1.0f));
        if (this.ticksBetweenWaves == 0) {
            this.nextWave();
        }
    }

    private void tickOngoing() {
        this.bossInfo.func_186735_a(MathHelper.func_76131_a((float)(1.0f - (float)this.undeadKilled / (float)this.undeadToKill), (float)0.0f, (float)1.0f));
        if (this.countNearbyPlayers() == 0) {
            this.status = Status.STOPPED;
        }
        if (!this.spawnerWasCreated && this.countNearbyUndeadArmy(10.0) >= this.undeadToKill / 2) {
            this.createSpawner();
        }
        if (this.shouldWaveEndPrematurely()) {
            this.killAllUndeadArmyEntities();
        }
        if (this.undeadKilled == this.undeadToKill) {
            this.endWave();
        }
        if (this.shouldEntitiesBeHighlighted()) {
            this.highlightUndeadArmy();
        }
        ++this.ticksWaveActive;
    }

    private void tickFinished() {
        this.ticksBetweenWaves = Math.max(this.ticksBetweenWaves - 1, 0);
        if (this.ticksBetweenWaves == 0) {
            this.finish();
        }
    }

    private void tickStopped() {
        ++this.ticksInactive;
        if (this.countNearbyPlayers() > 0) {
            this.status = Status.ONGOING;
        }
        if (this.ticksInactive >= this.ticksInactiveMaximum) {
            this.status = Status.FAILED;
            this.ticksBetweenWaves = this.ticksBetweenWavesMaximum * 2;
            this.bossInfo.func_186735_a(1.0f);
            this.spawnerWasCreated = false;
            this.createSpawner();
        }
    }

    public void increaseUndeadCounter() {
        this.undeadKilled = Math.min(this.undeadKilled + 1, this.undeadToKill);
    }

    public void highlightUndeadArmy() {
        for (MonsterEntity monster : this.getNearbyUndeadArmy(70.0)) {
            EffectHelper.applyEffectIfPossible((LivingEntity)monster, (Effect)Effects.field_188423_x, (int)TimeConverter.secondsToTicks((double)15.0), (int)5);
        }
    }

    public int countUndeadEntitiesLeft() {
        return this.countNearbyUndeadArmy(70.0);
    }

    public void updateNearbyUndeadAIGoals() {
        List<MonsterEntity> monsters = this.getNearbyUndeadArmy(70.0);
        for (MonsterEntity monster : monsters) {
            this.updateUndeadAIGoal(monster);
        }
    }

    public void finish() {
        this.isActive = false;
        this.bossInfo.func_201360_b();
    }

    public void killAllUndeadArmyEntities() {
        for (MonsterEntity monster : this.getNearbyUndeadArmy(70.0)) {
            monster.func_70097_a(DamageSource.field_76376_m, 9001.0f);
        }
        this.undeadKilled = this.undeadToKill;
    }

    private void nextWave() {
        ++this.currentWave;
        this.status = Status.ONGOING;
        this.ticksWaveActive = 0;
        this.spawnWaveEnemies();
        this.updateBarText();
    }

    private void endWave() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        if (this.currentWave >= config.getWaves()) {
            this.status = Status.VICTORY;
            this.ticksBetweenWaves = this.ticksBetweenWavesMaximum * 2;
            this.rewardPlayers();
            this.bossInfo.func_186735_a(1.0f);
        } else {
            this.status = Status.BETWEEN_WAVES;
            this.ticksBetweenWaves = this.ticksBetweenWavesMaximum;
        }
        this.updateBarText();
    }

    private void createSpawner() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        int spawnerRange = 5;
        for (int i = 0; i < 50 && !this.spawnerWasCreated; ++i) {
            int z;
            int y;
            int x = this.positionToAttack.func_177958_n() + MajruszLibrary.RANDOM.nextInt(spawnerRange * 2 + 1) - spawnerRange;
            BlockPos position = new BlockPos(x, y = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = this.positionToAttack.func_177952_p() + MajruszLibrary.RANDOM.nextInt(spawnerRange * 2 + 1) - spawnerRange), z);
            if (!this.world.func_175623_d(position)) continue;
            this.world.func_175656_a(position, Blocks.field_150474_ac.func_176223_P());
            this.spawnerWasCreated = true;
            TileEntity tileEntity = this.world.func_175625_s(position);
            if (!(tileEntity instanceof MobSpawnerTileEntity)) continue;
            ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(config.getEntityTypeForMonsterSpawner());
            this.world.func_195598_a((IParticleData)ParticleTypes.field_197601_L, (double)x, (double)y, (double)z, 40, 0.5, 0.5, 0.5, 0.01);
        }
        this.spawnerWasCreated = true;
    }

    private void spawnWaveEnemies() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        double playersFactor = config.getSizeMultiplier(this.countNearbyPlayers());
        this.undeadToKill = 0;
        this.undeadKilled = 0;
        for (WaveMember waveMember : WaveMember.values()) {
            for (int i = 0; i < (int)(playersFactor * (double)waveMember.waveCounts[this.currentWave - 1]); ++i) {
                BlockPos randomPosition = this.direction.getRandomSpawnPosition(this.world, this.positionToAttack, 70);
                MonsterEntity monster = (MonsterEntity)waveMember.type.func_220349_b(this.world, null, null, null, randomPosition, SpawnReason.EVENT, true, true);
                if (monster == null) continue;
                monster.func_110163_bv();
                this.updateUndeadAIGoal(monster);
                this.equipWithDyedLeatherArmor(monster);
                this.tryToEnchantEquipment(monster);
                this.markAsUndeadArmyUnit(monster);
                if (ForgeEventFactory.doSpecialSpawn((MobEntity)monster, (World)this.world, (float)randomPosition.func_177958_n(), (float)randomPosition.func_177956_o(), (float)randomPosition.func_177952_p(), null, (SpawnReason)SpawnReason.EVENT)) continue;
                this.world.func_242417_l((Entity)monster);
                ++this.undeadToKill;
            }
        }
        int x = this.positionToAttack.func_177958_n() + this.direction.x * 70;
        int z = this.positionToAttack.func_177952_p() + this.direction.z * 70;
        for (ServerPlayerEntity player : this.getNearbyPlayers()) {
            player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(Instances.Sounds.UNDEAD_ARMY_WAVE_STARTED, SoundCategory.NEUTRAL, (double)x, player.func_226278_cu_(), (double)z, 64.0f, 1.0f));
        }
        this.undeadToKill = Math.max(this.undeadToKill, 1);
    }

    private boolean shouldEntitiesBeHighlighted() {
        return this.ticksWaveActive >= TimeConverter.minutesToTicks((double)1.5) && this.ticksWaveActive % 100 == 0 && this.undeadKilled > this.undeadToKill / 2;
    }

    private boolean shouldWaveEndPrematurely() {
        boolean isOnlyFewUndeadLeft = (double)this.undeadKilled >= (double)this.undeadToKill * 0.8 && this.countUndeadEntitiesLeft() < 3;
        return isOnlyFewUndeadLeft && this.ticksWaveActive >= TimeConverter.minutesToTicks((double)2.5);
    }

    private void tryToEnchantEquipment(MonsterEntity monster) {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        double clampedRegionalDifficulty = GameState.getRegionalDifficulty((LivingEntity)monster);
        if (monster.func_190630_a(EquipmentSlotType.MAINHAND) && Random.tryChance((double)config.getEnchantedItemChance())) {
            monster.func_184611_a(Hand.MAIN_HAND, ItemHelper.enchantItem((ItemStack)monster.func_184614_ca(), (double)clampedRegionalDifficulty, (boolean)false));
        }
        for (ItemStack armor : monster.func_184193_aE()) {
            if (!Random.tryChance((double)(config.getEnchantedItemChance() / 2.0)) || (armor = ItemHelper.enchantItem((ItemStack)armor, (double)clampedRegionalDifficulty, (boolean)false)).getEquipmentSlot() == null) continue;
            monster.func_184201_a(armor.getEquipmentSlot(), armor);
        }
    }

    private void equipWithDyedLeatherArmor(MonsterEntity monster) {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        double armorPieceChance = config.getArmorPieceChance();
        this.equipWithArmorPiece(monster, Items.field_151024_Q, EquipmentSlotType.HEAD, "helmet", 1.0);
        this.equipWithArmorPiece(monster, Items.field_151027_R, EquipmentSlotType.CHEST, "chestplate", armorPieceChance);
        this.equipWithArmorPiece(monster, Items.field_151026_S, EquipmentSlotType.LEGS, "leggings", armorPieceChance);
        this.equipWithArmorPiece(monster, Items.field_151021_T, EquipmentSlotType.FEET, "boots", armorPieceChance);
    }

    private void equipWithArmorPiece(MonsterEntity monster, Item item, EquipmentSlotType equipmentSlotType, String registerName, double chance) {
        if (Random.tryChance((double)(1.0 - chance))) {
            return;
        }
        ItemStack armorPiece = new ItemStack((IItemProvider)item);
        this.setUndeadArmyColorAndName(armorPiece, registerName);
        ItemHelper.damageItem((ItemStack)armorPiece, (double)0.75);
        monster.func_184201_a(equipmentSlotType, armorPiece);
    }

    private void setUndeadArmyColorAndName(ItemStack armor, String registerName) {
        CompoundNBT nbt = armor.func_190925_c("display");
        nbt.func_74768_a("color", 9595003);
        nbt.func_74778_a("Name", "{\"translate\":\"majruszs_difficulty.items.undead_" + registerName + "\",\"italic\":false}");
        armor.func_77983_a("display", (INBT)nbt);
    }

    private void rewardPlayers() {
        UndeadArmyConfig config = Instances.UNDEAD_ARMY_CONFIG;
        for (PlayerEntity player : this.world.func_217490_a(this.getParticipantsPredicate())) {
            int i;
            Vector3d position = player.func_213303_ch();
            for (i = 0; i < config.getAmountOfVictoryExperience() / 4; ++i) {
                this.world.func_217376_c((Entity)new ExperienceOrbEntity((World)this.world, position.func_82615_a(), position.func_82617_b() + 1.0, position.func_82616_c(), 4));
            }
            if (!Instances.UNDEAD_ARMY_TREASURE_BAG.isAvailable()) continue;
            for (i = 0; i < config.getAmountOfVictoryTreasureBags(); ++i) {
                ItemHelper.giveItemStackToPlayer((ItemStack)new ItemStack((IItemProvider)Instances.UNDEAD_ARMY_TREASURE_BAG), (PlayerEntity)player, (ServerWorld)this.world);
            }
        }
    }

    private void markAsUndeadArmyUnit(MonsterEntity monster) {
        NBTHelper.saveBlockPos((CompoundNBT)monster.getPersistentData(), (String)"UndeadArmyPosition", (BlockPos)this.positionToAttack);
    }

    private void updateUndeadAIGoal(MonsterEntity monster) {
        monster.field_70714_bg.func_75776_a(4, (Goal)new UndeadAttackPositionGoal((MobEntity)monster, this.getAttackPosition(), 1.25, 20.0f, 3.0f));
    }

    private void updateUndeadArmyBarVisibility() {
        HashSet currentPlayers = Sets.newHashSet((Iterable)this.bossInfo.func_186757_c());
        List<ServerPlayerEntity> validPlayers = this.getNearbyPlayers();
        for (ServerPlayerEntity player : validPlayers) {
            if (currentPlayers.contains(player)) continue;
            this.bossInfo.func_186760_a(player);
        }
        for (ServerPlayerEntity player : currentPlayers) {
            if (validPlayers.contains(player)) continue;
            this.bossInfo.func_186761_b(player);
        }
    }

    private AxisAlignedBB getAxisAligned(double range) {
        Vector3i vector = new Vector3i(range, range, range);
        return new AxisAlignedBB(this.getAttackPosition().func_177973_b(vector), this.getAttackPosition().func_177971_a(vector));
    }

    private Predicate<MonsterEntity> getUndeadParticipantsPredicate() {
        return monster -> monster.func_70089_S() && UndeadArmy.doesEntityBelongToUndeadArmy((LivingEntity)monster);
    }

    private List<MonsterEntity> getNearbyUndeadArmy(double range) {
        return this.world.func_175647_a(MonsterEntity.class, this.getAxisAligned(range), this.getUndeadParticipantsPredicate());
    }

    private int countNearbyUndeadArmy(double range) {
        return this.getNearbyUndeadArmy(range).size();
    }

    private Predicate<ServerPlayerEntity> getParticipantsPredicate() {
        return player -> player.func_70089_S() && RegistryHandler.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(new BlockPos(player.func_213303_ch())) == this;
    }

    private List<ServerPlayerEntity> getNearbyPlayers() {
        return this.world.func_217490_a(this.getParticipantsPredicate());
    }

    private int countNearbyPlayers() {
        return this.getNearbyPlayers().size();
    }
}

