/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.config.GameStateDoubleConfig;
import com.majruszs_difficulty.config.GameStateIntegerConfig;
import com.majruszs_difficulty.entities.EliteSkeletonEntity;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import net.minecraft.entity.EntityType;

public class UndeadArmyConfig {
    private final ConfigGroup group;
    private final AvailabilityConfig availability;
    private final IntegerConfig killRequirement;
    private final DoubleConfig sizeMultiplier;
    private final GameStateIntegerConfig experienceReward;
    private final GameStateIntegerConfig treasureBagReward;
    private final GameStateDoubleConfig enchantedItemsChance;
    private final GameStateDoubleConfig armorChance;
    private final DurationConfig durationBetweenWaves;
    private final DurationConfig maximumInactiveDuration;

    public UndeadArmyConfig() {
        String availabilityComment = "Is the Undead Army enabled?";
        this.availability = new AvailabilityConfig("is_enabled", availabilityComment, false, true);
        String killComment = "Required amount of killed undead to start the Undead Army.";
        this.killRequirement = new IntegerConfig("kill_requirement", killComment, false, 100, 10, 1000);
        String sizeComment = "Extra size multiplier for each extra player participating in the Undead Army.";
        this.sizeMultiplier = new DoubleConfig("player_scale", sizeComment, false, 0.5, 0.1, 1.0);
        String expComment = "Experience for each player after defeating the Undead Army.";
        this.experienceReward = new GameStateIntegerConfig("Experience", expComment, 40, 80, 120, 4, 1000);
        String bagComment = "Treasure Bags for each player after defeating the Undead Army.";
        this.treasureBagReward = new GameStateIntegerConfig("TreasureBags", bagComment, 1, 1, 2, 1, 5);
        String enchantComment = "Chance of the undead to have enchanted items. (separate for each item)";
        this.enchantedItemsChance = new GameStateDoubleConfig("EnchantedItems", enchantComment, 0.125, 0.25, 0.5, 0.0, 1.0);
        String armorComment = "Chance of the undead to have armor piece. (separate for each armor piece)";
        this.armorChance = new GameStateDoubleConfig("ArmorChance", armorComment, 0.25, 0.5, 0.75, 0.0, 1.0);
        String waveComment = "Time between waves. (in seconds) (requires game/world restart!) ";
        this.durationBetweenWaves = new DurationConfig("time_between_waves", waveComment, true, 10.0, 3.0, 60.0);
        String inactiveComment = "The maximum duration before Undead Army will end if there is no player. (in seconds) (requires game/world restart!) ";
        this.maximumInactiveDuration = new DurationConfig("inactive_duration", inactiveComment, true, 900.0, 300.0, 3200.0);
        this.group = MajruszsDifficulty.CONFIG_HANDLER.addConfigGroup(new ConfigGroup("UndeadArmy", ""));
        this.group.addConfigs(new IConfig[]{this.availability, this.killRequirement, this.sizeMultiplier, this.experienceReward, this.treasureBagReward, this.enchantedItemsChance, this.armorChance, this.durationBetweenWaves, this.maximumInactiveDuration});
    }

    public boolean isUndeadArmyDisabled() {
        return this.availability.isDisabled();
    }

    public int getRequiredKills() {
        return this.killRequirement.get();
    }

    public double getSizeMultiplier(int amountOfPlayers) {
        return 1.0 + this.sizeMultiplier.get() * (double)(Math.max(1, amountOfPlayers) - 1);
    }

    public int getAmountOfVictoryExperience() {
        return this.experienceReward.getCurrentGameStateValue();
    }

    public int getAmountOfVictoryTreasureBags() {
        return this.treasureBagReward.getCurrentGameStateValue();
    }

    public double getEnchantedItemChance() {
        return this.enchantedItemsChance.getCurrentGameStateValue();
    }

    public double getArmorPieceChance() {
        return this.armorChance.getCurrentGameStateValue();
    }

    public int getAmountOfTicksBetweenWaves() {
        return this.durationBetweenWaves.getDuration();
    }

    public int getAmountOfInactivityTicks() {
        return this.maximumInactiveDuration.getDuration();
    }

    public int getWaves() {
        return GameState.getValueDependingOnCurrentGameState(3, 4, 5);
    }

    public EntityType<?> getEntityTypeForMonsterSpawner() {
        return GameState.getValueDependingOnCurrentGameState(EntityType.field_200725_aD, EntityType.field_200741_ag, EliteSkeletonEntity.type);
    }
}

