/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.undead_army;

import com.majruszs_difficulty.features.undead_army.Direction;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class UndeadArmyText {
    public static final ITextComponent TITLE = new TranslationTextComponent("majruszs_difficulty.undead_army.title");
    public static final ITextComponent WAVE = new TranslationTextComponent("majruszs_difficulty.undead_army.wave");
    public static final ITextComponent BETWEEN_WAVES = new TranslationTextComponent("majruszs_difficulty.undead_army.between_waves");
    public static final ITextComponent VICTORY = new TranslationTextComponent("majruszs_difficulty.undead_army.victory");
    public static final ITextComponent FAILED = new TranslationTextComponent("majruszs_difficulty.undead_army.failed");
    public static final ITextComponent APPROACHING = new TranslationTextComponent("majruszs_difficulty.undead_army.approaching");

    public static ITextComponent getWaveMessage(int currentWave) {
        StringTextComponent message = new StringTextComponent("");
        message.func_230529_a_(TITLE);
        message.func_240702_b_(" (");
        message.func_230529_a_(WAVE);
        message.func_240702_b_(" " + currentWave + ")");
        return message;
    }

    public static void notifyAboutStart(List<ServerPlayerEntity> players, Direction direction) {
        String directionAsString = direction.toString();
        IFormattableTextComponent message = APPROACHING.func_230531_f_();
        message.func_240702_b_(" ");
        message.func_230529_a_((ITextComponent)new TranslationTextComponent("majruszs_difficulty.undead_army." + directionAsString.toLowerCase()));
        message.func_240702_b_("!");
        message.func_240699_a_(TextFormatting.BOLD);
        message.func_240699_a_(TextFormatting.DARK_PURPLE);
        for (ServerPlayerEntity player : players) {
            player.func_146105_b((ITextComponent)message, false);
        }
    }
}

