/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.when_damaged.WhenDamagedApplyEffectBase;
import com.mlib.TimeConverter;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.IConfig;
import com.mlib.effects.EffectHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class NauseaAndSlownessWhenFalling
extends WhenDamagedApplyEffectBase {
    private static final String CONFIG_NAME = "FallEffects";
    private static final String CONFIG_COMMENT = "Applies Nausea and Slowness on fall.";
    protected final AvailabilityConfig nauseaAvailability;
    protected final AvailabilityConfig slownessAvailability;

    public NauseaAndSlownessWhenFalling() {
        super(CONFIG_NAME, CONFIG_COMMENT, 1.0, 10.0, GameState.State.NORMAL, false, new Effect[]{Effects.field_76431_k, Effects.field_76421_d});
        String nauseaComment = "Is applying Nausea enabled?";
        String slownessComment = "Is applying Slowness enabled?";
        this.nauseaAvailability = new AvailabilityConfig("nausea", nauseaComment, false, true);
        this.slownessAvailability = new AvailabilityConfig("slowness", slownessComment, false, true);
        this.featureGroup.addConfigs(new IConfig[]{this.nauseaAvailability, this.slownessAvailability});
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        return damageSource.equals(DamageSource.field_76379_h) && super.shouldBeExecuted(attacker, target, damageSource);
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        float damage = event.getAmount();
        if (damage < 1.5f) {
            return;
        }
        ServerWorld world = (ServerWorld)target.func_130014_f_();
        for (Effect effect : this.effects) {
            if (!this.tryChance(target)) continue;
            if (effect == Effects.field_76421_d && this.slownessAvailability.isEnabled()) {
                EffectHelper.applyEffectIfPossible((LivingEntity)target, (Effect)effect, (int)(this.getDurationInTicks(world.func_175659_aa()) + TimeConverter.secondsToTicks((double)((double)damage * 0.5))), (int)((int)((double)damage / 8.0)));
                continue;
            }
            if (effect != Effects.field_76431_k || !this.nauseaAvailability.isEnabled()) continue;
            EffectHelper.applyEffectIfPossible((LivingEntity)target, (Effect)effect, (int)TimeConverter.secondsToTicks((double)6.0), (int)((int)((double)damage / 6.0)));
        }
    }

    @Override
    protected int getAmplifier(Difficulty difficulty) {
        return 0;
    }
}

