/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.blocks.EndShardOre;
import com.majruszs_difficulty.features.when_damaged.WhenDamagedBase;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class TriggerAllEndermansOnAttack
extends WhenDamagedBase {
    private static final String CONFIG_NAME = "EndermanAttack";
    private static final String CONFIG_COMMENT = "Makes all nearby enderman target player when it hits any of them.";

    public TriggerAllEndermansOnAttack() {
        super(CONFIG_NAME, CONFIG_COMMENT, GameState.State.MASTER);
    }

    @Override
    public void whenDamaged(@Nullable LivingEntity attacker, LivingEntity target, LivingHurtEvent event) {
        if (attacker != null) {
            EndShardOre.targetEndermansOnEntity(attacker, 500.0);
        }
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        return attacker != null && target instanceof EndermanEntity && super.shouldBeExecuted(attacker, target, damageSource);
    }
}

