/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.effects.BleedingEffect;
import com.majruszs_difficulty.features.when_damaged.WhenDamagedApplyEffectBase;
import com.mlib.effects.EffectHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Difficulty;

public abstract class WhenDamagedApplyBleedingBase
extends WhenDamagedApplyEffectBase {
    public WhenDamagedApplyBleedingBase(String configName, String configComment, double defaultChance, double defaultDurationInSeconds) {
        super(configName, configComment, defaultChance, defaultDurationInSeconds, GameState.State.NORMAL, false, Instances.BLEEDING);
    }

    @Override
    public boolean shouldBeExecuted(@Nullable LivingEntity attacker, LivingEntity target, DamageSource damageSource) {
        return Instances.BLEEDING.mayBleed((Entity)target) && !(damageSource instanceof BleedingEffect.EntityBleedingDamageSource) && super.shouldBeExecuted(attacker, target, damageSource);
    }

    @Override
    protected void applyEffect(@Nullable LivingEntity attacker, LivingEntity target, Effect effect, Difficulty difficulty) {
        BleedingEffect.BleedingEffectInstance effectInstance = new BleedingEffect.BleedingEffectInstance(this.getDurationInTicks(difficulty), this.getAmplifier(difficulty), false, true, attacker);
        EffectHelper.applyEffectIfPossible((LivingEntity)target, (EffectInstance)effectInstance);
    }

    @Override
    protected int getAmplifier(Difficulty difficulty) {
        return Instances.BLEEDING.getAmplifier();
    }

    @Override
    public double calculateChance(LivingEntity target) {
        return Instances.BLEEDING.getChanceMultiplierDependingOnArmor(target) * super.calculateChance(target);
    }
}

