/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.features.when_damaged;

import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.features.when_damaged.WhenDamagedApplyEffectBase;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.Difficulty;

public abstract class WhenDamagedApplyStackableEffectBase
extends WhenDamagedApplyEffectBase {
    protected final boolean isAmplifierStackable;
    protected final boolean isDurationStackable;
    protected final int maximumAmplifier;
    protected final int maximumDurationInTicks;

    public WhenDamagedApplyStackableEffectBase(String configName, String configComment, double defaultChance, double defaultDurationInSeconds, GameState.State minimumState, boolean shouldBeMultipliedByCRD, Effect[] effects, boolean isAmplifierStackable, boolean isDurationStackable, int maximumAmplifier, int maximumDurationInTicks) {
        super(configName, configComment, defaultChance, defaultDurationInSeconds, minimumState, shouldBeMultipliedByCRD, effects);
        this.isAmplifierStackable = isAmplifierStackable;
        this.isDurationStackable = isDurationStackable;
        this.maximumAmplifier = maximumAmplifier;
        this.maximumDurationInTicks = maximumDurationInTicks;
    }

    public WhenDamagedApplyStackableEffectBase(String configName, String configComment, double defaultChance, double defaultDurationInSeconds, GameState.State minimumState, boolean shouldBeMultipliedByCRD, Effect effect, boolean isAmplifierStackable, boolean isDurationStackable, int maximumAmplifier, int maximumDurationInTicks) {
        this(configName, configComment, defaultChance, defaultDurationInSeconds, minimumState, shouldBeMultipliedByCRD, new Effect[]{effect}, isAmplifierStackable, isDurationStackable, maximumAmplifier, maximumDurationInTicks);
    }

    @Override
    protected void applyEffect(@Nullable LivingEntity attacker, LivingEntity target, Effect effect, Difficulty difficulty) {
        EffectInstance effectInstance;
        EffectInstance previousEffectInstance = target.func_70660_b(effect);
        if (previousEffectInstance == null) {
            super.applyEffect(attacker, target, effect, difficulty);
            return;
        }
        int durationInTicks = this.getDurationInTicks(difficulty);
        if (this.isDurationStackable) {
            durationInTicks = Math.min(durationInTicks + previousEffectInstance.func_76459_b(), this.maximumDurationInTicks);
        }
        int amplifier = this.getAmplifier(difficulty);
        if (this.isAmplifierStackable) {
            amplifier = Math.min(amplifier + previousEffectInstance.func_76458_c() + 1, this.maximumAmplifier);
        }
        if (target.func_70687_e(effectInstance = new EffectInstance(effect, durationInTicks, amplifier))) {
            target.func_195064_c(effectInstance);
        }
    }
}

