/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.generation.structure_pieces;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.entities.SkyKeeperEntity;
import com.mlib.MajruszLibrary;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.spawner.AbstractSpawner;

public class FlyingEndIslandPiece
extends TemplateStructurePiece {
    public static final List<ResourceLocation> BUILDING_ISLAND_RESOURCE_LOCATIONS = new ArrayList<ResourceLocation>();
    public static final List<ResourceLocation> EMPTY_ISLAND_RESOURCE_LOCATIONS = new ArrayList<ResourceLocation>();
    public static final ResourceLocation DUNGEON_CHEST_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_island_dungeon");
    public static final ResourceLocation TOWER_CHEST_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_island_tower");
    public static final ResourceLocation ARCHER_CHEST_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_island_archer_tower");
    public static final ResourceLocation POTION_CHEST_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_island_potion");
    public static final ResourceLocation FORGE_CHEST_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/end_island_forge");
    private final Rotation rotation;

    public FlyingEndIslandPiece(TemplateManager templateManager, BlockPos position, Rotation rotation) {
        super(Instances.FLYING_END_ISLAND_PIECE, 0);
        this.field_186178_c = position;
        this.rotation = rotation;
        this.setupPiece(templateManager);
    }

    public FlyingEndIslandPiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
        super(Instances.FLYING_END_ISLAND_PIECE, compoundNBT);
        this.rotation = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
        this.setupPiece(templateManager);
    }

    protected void func_143011_b(CompoundNBT compoundNBT) {
        super.func_143011_b(compoundNBT);
        compoundNBT.func_74778_a("Rot", this.rotation.name());
    }

    protected void func_186175_a(String function, BlockPos position, IServerWorld world, Random random, MutableBoundingBox boundingBox) {
        if (function.startsWith("chest")) {
            TileEntity tileEntity = world.func_175625_s(position.func_177977_b());
            if (tileEntity instanceof ChestTileEntity) {
                ChestTileEntity chest = (ChestTileEntity)tileEntity;
                if (function.startsWith("chest_dung")) {
                    if (com.mlib.Random.tryChance((double)0.3)) {
                        chest.func_189404_a(DUNGEON_CHEST_RESOURCE_LOCATION, random.nextLong());
                    } else {
                        world.func_180501_a(position.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                } else if (function.startsWith("chest_tower")) {
                    chest.func_189404_a(TOWER_CHEST_RESOURCE_LOCATION, random.nextLong());
                } else if (function.startsWith("chest_archer")) {
                    chest.func_189404_a(ARCHER_CHEST_RESOURCE_LOCATION, random.nextLong());
                } else if (function.startsWith("chest_potion")) {
                    chest.func_189404_a(POTION_CHEST_RESOURCE_LOCATION, random.nextLong());
                } else if (function.startsWith("chest_forge")) {
                    chest.func_189404_a(FORGE_CHEST_RESOURCE_LOCATION, random.nextLong());
                }
            }
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
        } else if (function.startsWith("shulker")) {
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            ShulkerEntity monster = (ShulkerEntity)EntityType.field_200738_ad.func_200721_a((World)world.func_201672_e());
            if (monster != null) {
                monster.func_110163_bv();
                monster.func_70107_b((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p());
                world.func_217376_c((Entity)monster);
            }
        } else if (function.startsWith("end_keeper")) {
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            SkyKeeperEntity monster = (SkyKeeperEntity)SkyKeeperEntity.type.func_200721_a((World)world.func_201672_e());
            if (monster != null) {
                monster.func_110163_bv();
                monster.func_70107_b(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
                world.func_217376_c((Entity)monster);
            }
        } else if (function.startsWith("spawner")) {
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(position.func_177977_b(), Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tileEntity = world.func_175625_s(position.func_177977_b());
            if (tileEntity instanceof MobSpawnerTileEntity) {
                MobSpawnerTileEntity mobSpawnerTileEntity = (MobSpawnerTileEntity)tileEntity;
                AbstractSpawner abstractSpawner = mobSpawnerTileEntity.func_145881_a();
                abstractSpawner.func_200876_a(EntityType.field_200804_r);
            }
        }
    }

    public static void start(TemplateManager templateManager, BlockPos position, Rotation rotation, List<StructurePiece> pieces, Random random) {
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        pieces.add((StructurePiece)new FlyingEndIslandPiece(templateManager, blockpos, rotation));
    }

    private void setupPiece(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.getRandomResourceLocation());
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    private ResourceLocation getRandomResourceLocation() {
        if (com.mlib.Random.tryChance((double)Instances.FLYING_END_ISLAND.buildingIslandChance.get())) {
            return BUILDING_ISLAND_RESOURCE_LOCATIONS.get(MajruszLibrary.RANDOM.nextInt(BUILDING_ISLAND_RESOURCE_LOCATIONS.size()));
        }
        return EMPTY_ISLAND_RESOURCE_LOCATIONS.get(MajruszLibrary.RANDOM.nextInt(EMPTY_ISLAND_RESOURCE_LOCATIONS.size()));
    }

    static {
        BUILDING_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_tower_1"));
        BUILDING_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_tower_2"));
        BUILDING_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_dungeon"));
        BUILDING_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_alchemist"));
        BUILDING_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_archer_tower"));
        BUILDING_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_forge"));
        EMPTY_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_empty_1"));
        EMPTY_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_empty_2"));
        EMPTY_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_empty_3"));
        EMPTY_ISLAND_RESOURCE_LOCATIONS.add(MajruszsDifficulty.getLocation("end_island_empty_4"));
    }
}

