/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.generation.structure_pieces;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.entities.SkyKeeperEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class FlyingPhantomPiece
extends TemplateStructurePiece {
    public static final ResourceLocation RESOURCE_LOCATION = MajruszsDifficulty.getLocation("flying_phantom");
    public static final ResourceLocation CHEST_RESOURCE_LOCATION = MajruszsDifficulty.getLocation("chests/flying_phantom");
    private final Rotation rotation;

    public FlyingPhantomPiece(TemplateManager templateManager, BlockPos position, Rotation rotation) {
        super(Instances.FLYING_PHANTOM_PIECE, 0);
        this.field_186178_c = position;
        this.rotation = rotation;
        this.setupPiece(templateManager);
    }

    public FlyingPhantomPiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
        super(Instances.FLYING_PHANTOM_PIECE, compoundNBT);
        this.rotation = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
        this.setupPiece(templateManager);
    }

    protected void func_143011_b(CompoundNBT compoundNBT) {
        super.func_143011_b(compoundNBT);
        compoundNBT.func_74778_a("Rot", this.rotation.name());
    }

    protected void func_186175_a(String function, BlockPos position, IServerWorld world, Random random, MutableBoundingBox boundingBox) {
        if (function.startsWith("chest")) {
            TileEntity tileEntity = world.func_175625_s(position.func_177977_b());
            if (tileEntity instanceof ChestTileEntity) {
                ((ChestTileEntity)tileEntity).func_189404_a(CHEST_RESOURCE_LOCATION, random.nextLong());
            }
        } else if (function.startsWith("sky_keeper")) {
            SkyKeeperEntity monster = (SkyKeeperEntity)SkyKeeperEntity.type.func_200721_a((World)world.func_201672_e());
            if (monster != null) {
                monster.func_110163_bv();
                monster.func_70107_b(position.func_177958_n(), position.func_177956_o() + 3, position.func_177952_p());
                world.func_217376_c((Entity)monster);
            }
        } else if (function.startsWith("phantom")) {
            PhantomEntity monster = (PhantomEntity)EntityType.field_203097_aH.func_200721_a((World)world.func_201672_e());
            if (monster != null) {
                monster.func_110163_bv();
                monster.func_70107_b((double)position.func_177958_n(), (double)(position.func_177956_o() + 3), (double)position.func_177952_p());
                world.func_217376_c((Entity)monster);
            }
        } else {
            return;
        }
        world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
    }

    public static void start(TemplateManager templateManager, BlockPos position, Rotation rotation, List<StructurePiece> pieces, Random random) {
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        pieces.add((StructurePiece)new FlyingPhantomPiece(templateManager, blockpos, rotation));
    }

    private void setupPiece(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(RESOURCE_LOCATION);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }
}

