/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.goals;

import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;

public class FollowGroupLeaderGoal
extends Goal {
    protected final MobEntity follower;
    protected final MobEntity leader;
    private final PathNavigator navigation;
    protected final double speedModifier;
    protected final float maxDistanceFromLeader;
    protected final float stopDistance;
    protected int ticksToRecalculatePath;

    public FollowGroupLeaderGoal(MobEntity follower, MobEntity leader, double speedModifier, float maxDistanceFromLeader, float stopDistance) {
        this.follower = follower;
        this.leader = leader;
        this.navigation = follower.func_70661_as();
        this.speedModifier = speedModifier;
        this.maxDistanceFromLeader = maxDistanceFromLeader;
        this.stopDistance = stopDistance;
        this.ticksToRecalculatePath = 0;
    }

    public boolean func_75250_a() {
        return this.leader != null && this.leader.func_70089_S() && this.leader.func_70032_d((Entity)this.follower) >= this.maxDistanceFromLeader && this.follower.func_70638_az() == null;
    }

    public boolean func_75253_b() {
        return this.leader != null && !this.navigation.func_75500_f() && (double)this.follower.func_70032_d((Entity)this.leader) > (double)this.stopDistance;
    }

    public void func_75249_e() {
        this.ticksToRecalculatePath = 0;
    }

    public void func_75246_d() {
        if (this.leader == null) {
            return;
        }
        if (--this.ticksToRecalculatePath > 0) {
            return;
        }
        this.follower.func_70671_ap().func_75651_a((Entity)this.leader, 10.0f, (float)this.follower.func_70646_bf());
        this.ticksToRecalculatePath = 10;
        double distance = this.follower.func_70032_d((Entity)this.leader);
        if (distance <= (double)this.maxDistanceFromLeader) {
            this.recalculatePath(distance);
        } else {
            this.navigation.func_75497_a((Entity)this.leader, this.speedModifier);
        }
    }

    protected void recalculatePath(double distance) {
        this.navigation.func_75499_g();
        LookController lookcontroller = this.leader.func_70671_ap();
        if (distance <= (double)this.maxDistanceFromLeader || lookcontroller.func_180423_e() == this.follower.func_226277_ct_() && lookcontroller.func_180422_f() == this.follower.func_226278_cu_() && lookcontroller.func_180421_g() == this.follower.func_226281_cx_()) {
            double d4 = this.follower.func_226277_ct_() - this.leader.func_226277_ct_();
            double d5 = this.follower.func_226281_cx_() - this.leader.func_226281_cx_();
            this.navigation.func_75492_a(this.follower.func_226277_ct_() - d4, this.follower.func_226278_cu_(), this.follower.func_226281_cx_() - d5, this.speedModifier);
        }
    }
}

