/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.effects.BleedingEffect;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DurationConfig;
import com.mlib.config.IConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.effects.EffectHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BandageItem
extends Item {
    private static final String TOOLTIP_TRANSLATION_KEY_1 = "item.majruszs_difficulty.bandage.item_tooltip1";
    private static final String TOOLTIP_TRANSLATION_KEY_2 = "item.majruszs_difficulty.bandage.item_tooltip2";
    protected final ConfigGroup configGroup;
    protected final AvailabilityConfig isAlwaysUsable;
    protected final DurationConfig effectDuration;
    protected final IntegerConfig effectAmplifier;

    public BandageItem() {
        this("Bandage", 0, Rarity.COMMON);
    }

    public BandageItem(String name, int defaultAmplifier, Rarity rarity) {
        super(new Item.Properties().func_200917_a(16).func_200916_a(Instances.ITEM_GROUP).func_208103_a(rarity));
        this.configGroup = new ConfigGroup(name, "Configuration for " + name + " item.");
        MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)this.configGroup);
        String usableComment = "Is " + name + " always usable? If not player can only use " + name + " when it is bleeding.";
        String durationComment = "Duration in seconds of Regeneration effect.";
        String amplifierComment = "Level/amplifier of Regeneration effect.";
        this.isAlwaysUsable = new AvailabilityConfig("is_always_usable", usableComment, false, true);
        this.effectDuration = new DurationConfig("regeneration_duration", durationComment, false, 4.0, 1.0, 120.0);
        this.effectAmplifier = new IntegerConfig("regeneration_amplifier", amplifierComment, false, defaultAmplifier, 0, 10);
        this.configGroup.addConfigs(new IConfig[]{this.isAlwaysUsable, this.effectDuration, this.effectAmplifier});
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        this.useIfPossible(itemStack, player, (LivingEntity)player);
        return ActionResult.func_233538_a_((Object)itemStack, (boolean)world.func_201670_d());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        MajruszsHelper.addAdvancedTooltips(tooltip, flag, TOOLTIP_TRANSLATION_KEY_1, TOOLTIP_TRANSLATION_KEY_2);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getTarget() instanceof LivingEntity)) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (!(itemStack.func_77973_b() instanceof BandageItem)) {
            return;
        }
        BandageItem bandage = (BandageItem)itemStack.func_77973_b();
        if (bandage.useIfPossible(event.getItemStack(), event.getPlayer(), (LivingEntity)event.getTarget())) {
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    public boolean isAlwaysUsable() {
        return this.isAlwaysUsable.isEnabled();
    }

    public int getRegenerationDuration() {
        return this.effectDuration.getDuration();
    }

    public int getRegenerationAmplifier() {
        return this.effectAmplifier.get();
    }

    protected void applyEffects(LivingEntity target) {
        EffectHelper.applyEffectIfPossible((LivingEntity)target, (Effect)Effects.field_76428_l, (int)this.getRegenerationDuration(), (int)this.getRegenerationAmplifier());
    }

    private boolean useIfPossible(ItemStack bandage, PlayerEntity player, LivingEntity target) {
        if (!this.couldBeUsedOn(target, bandage)) {
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            bandage.func_190918_g(1);
        }
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)bandage.func_77973_b()));
        this.removeBleeding(target);
        this.applyEffects(target);
        target.field_70170_p.func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 1.0f, 1.0f);
        return true;
    }

    private boolean couldBeUsedOn(LivingEntity target, ItemStack bandage) {
        boolean isBandage = bandage.func_77973_b() instanceof BandageItem;
        boolean targetHasRegeneration = target.func_70644_a(Effects.field_76428_l);
        return isBandage && (this.isAlwaysUsable() && !targetHasRegeneration || target.func_70644_a((Effect)Instances.BLEEDING));
    }

    private void removeBleeding(LivingEntity target) {
        BleedingEffect bleeding = Instances.BLEEDING;
        target.func_195063_d((Effect)bleeding);
        target.func_184596_c((Effect)bleeding);
    }
}

