/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EndShardLocatorItem
extends Item {
    private static final String TOOLTIP_TRANSLATION_KEY = "item.majruszs_difficulty.end_shard_locator.item_tooltip";
    private static final String COUNTER_TAG = "EndShardLocatorCounter";
    private static final String POSITION_X_TAG = "EndShardLocatorX";
    private static final String POSITION_Y_TAG = "EndShardLocatorY";
    private static final String POSITION_Z_TAG = "EndShardLocatorZ";
    private static final int COORDINATE_FACTOR = 30;
    private static final float INVALID_DISTANCE = 9001.0f;

    public EndShardLocatorItem() {
        super(new Item.Properties().func_200916_a(Instances.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON).func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        MajruszsHelper.addExtraTooltipIfDisabled(tooltip, Instances.END_SHARD_ORE.isEnabled());
        MajruszsHelper.addAdvancedTooltip(tooltip, flag, TOOLTIP_TRANSLATION_KEY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float calculateDistanceToEndShard(ItemStack itemStack, @Nullable ClientWorld clientWorld, @Nullable LivingEntity entity) {
        if (entity == null) {
            return 9001.0f;
        }
        World world = entity.field_70170_p;
        Vector3d entityPosition = entity.func_213303_ch();
        CompoundNBT data = entity.getPersistentData();
        int counter = data.func_74762_e(COUNTER_TAG);
        BlockPos nearestEndShard = new BlockPos(data.func_74762_e(POSITION_X_TAG), data.func_74762_e(POSITION_Y_TAG), data.func_74762_e(POSITION_Z_TAG));
        BlockState currentBlockState = world.func_180495_p(nearestEndShard);
        boolean isValid = currentBlockState.func_177230_c() == Instances.END_SHARD_ORE;
        double closestDistance = entityPosition.func_72436_e(Vector3d.func_237489_a_((Vector3i)nearestEndShard));
        BlockPos endShardOre = EndShardLocatorItem.findNearestEndShard(world, entityPosition, counter - 30);
        if (endShardOre != null) {
            if (!isValid) {
                nearestEndShard = endShardOre;
            } else {
                double currentDistance = entityPosition.func_72436_e(Vector3d.func_237489_a_((Vector3i)endShardOre));
                if (currentDistance < closestDistance) {
                    nearestEndShard = endShardOre;
                }
            }
        }
        data.func_74768_a(COUNTER_TAG, (counter + 1) % 60);
        data.func_74768_a(POSITION_X_TAG, nearestEndShard.func_177958_n());
        data.func_74768_a(POSITION_Y_TAG, nearestEndShard.func_177956_o());
        data.func_74768_a(POSITION_Z_TAG, nearestEndShard.func_177952_p());
        return isValid ? (float)closestDistance : 9001.0f;
    }

    @Nullable
    private static BlockPos findNearestEndShard(World world, Vector3d entityPosition, int yFactor) {
        int y = (int)(entityPosition.field_72448_b + (double)yFactor);
        double closestDistance = 9001.0;
        BlockPos blockPosition = new BlockPos(0, 0, 0);
        int x = (int)(entityPosition.func_82615_a() - 30.0);
        while ((double)x < entityPosition.func_82615_a() + 30.0) {
            int z = (int)(entityPosition.func_82616_c() - 30.0);
            while ((double)z < entityPosition.func_82616_c() + 30.0) {
                double distance;
                BlockPos testPosition = new BlockPos(x, y, z);
                BlockState testBlockState = world.func_180495_p(testPosition);
                if (testBlockState.func_177230_c() == Instances.END_SHARD_ORE && (distance = entityPosition.func_72436_e(Vector3d.func_237489_a_((Vector3i)testPosition))) < closestDistance) {
                    closestDistance = distance;
                    blockPosition = testPosition;
                }
                ++z;
            }
            ++x;
        }
        return closestDistance == 9001.0 ? null : blockPosition;
    }
}

