/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.majruszs_difficulty.items.CustomArmorMaterial;
import com.majruszs_difficulty.models.HermesArmorModel;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HermesBootsItem
extends ArmorItem {
    protected static final AttributeHandler MOVEMENT_BONUS_ATTRIBUTE = new AttributeHandler("dbe472cb-df52-44ab-ab38-01b00e24f649", "HermesBootsMovementSpeedBonus", Attributes.field_233821_d_, AttributeModifier.Operation.MULTIPLY_BASE);
    protected final DoubleConfig movementSpeedBonus;
    protected final ConfigGroup configGroup;
    private static final String TOOLTIP_TRANSLATION_KEY = "item.majruszs_difficulty.hermes_boots.item_tooltip";

    public HermesBootsItem() {
        super((IArmorMaterial)CustomArmorMaterial.HERMES, EquipmentSlotType.FEET, new Item.Properties().func_200916_a(Instances.ITEM_GROUP).func_208103_a(Rarity.UNCOMMON));
        String comment = "Movement speed extra multiplier.";
        this.movementSpeedBonus = new DoubleConfig("movement_speed_bonus", comment, false, 0.25, 0.0, 1.0);
        this.configGroup = new ConfigGroup("HermesBoots", "Hermes Boots item configuration.");
        MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)this.configGroup);
        this.configGroup.addConfig((IConfig)this.movementSpeedBonus);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        MajruszsHelper.addAdvancedTooltip(tooltip, flag, TOOLTIP_TRANSLATION_KEY);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        ResourceLocation textureLocation = MajruszsDifficulty.getLocation("textures/models/armor/hermes_layer.png");
        return textureLocation.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <ArmorModel extends BipedModel<?>> ArmorModel getArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlotType armorSlot, ArmorModel defaultModel) {
        HermesArmorModel model = new HermesArmorModel();
        model.field_78116_c.field_78806_j = armorSlot == EquipmentSlotType.HEAD;
        model.field_178720_f.field_78806_j = false;
        model.field_78115_e.field_78806_j = armorSlot == EquipmentSlotType.CHEST;
        model.field_178724_i.field_78806_j = false;
        model.field_178723_h.field_78806_j = false;
        model.field_178721_j.field_78806_j = armorSlot == EquipmentSlotType.FEET;
        model.field_178722_k.field_78806_j = armorSlot == EquipmentSlotType.FEET;
        model.field_217114_e = defaultModel.field_217114_e;
        model.field_217113_d = defaultModel.field_217113_d;
        model.field_228270_o_ = defaultModel.field_228270_o_;
        model.field_187076_m = defaultModel.field_187076_m;
        model.field_187075_l = defaultModel.field_187075_l;
        return (ArmorModel)((Object)model);
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        MOVEMENT_BONUS_ATTRIBUTE.setValue(Instances.HERMES_BOOTS_ITEM.getMovementSpeedBonus(entity)).apply(entity);
    }

    public double getMovementSpeedBonus(LivingEntity entity) {
        ItemStack boots = entity.func_184582_a(EquipmentSlotType.FEET);
        return (boots.func_77973_b() instanceof HermesBootsItem ? 1.0 : 0.0) * this.movementSpeedBonus.get();
    }
}

