/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.loot_modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.majruszs_difficulty.GameState;
import com.mlib.Random;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class DoubleLoot
extends LootModifier {
    private final double normalModeChance;
    private final double expertModeChance;
    private final double masterModeChance;
    private final List<Item> forbiddenItemsToDuplicate;

    public DoubleLoot(ILootCondition[] conditions, double normalChance, double expertChance, double masterChance, List<Item> forbiddenItems) {
        super(conditions);
        this.normalModeChance = normalChance;
        this.expertModeChance = expertChance;
        this.masterModeChance = masterChance;
        this.forbiddenItemsToDuplicate = forbiddenItems;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        double chance = GameState.getValueDependingOnCurrentGameState(this.normalModeChance, this.expertModeChance, this.masterModeChance);
        if (Random.tryChance((double)chance)) {
            Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
            if (generatedLoot.size() > 0 && entity != null) {
                this.spawnParticles(entity);
            }
            return this.doubleLoot(generatedLoot);
        }
        return generatedLoot;
    }

    protected void spawnParticles(Entity entity) {
        if (!(entity.field_70170_p instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)entity.field_70170_p;
        for (int i = 0; i < 8; ++i) {
            world.func_195598_a((IParticleData)ParticleTypes.field_197632_y, entity.func_226277_ct_(), entity.func_226283_e_(0.5), entity.func_226281_cx_(), 1, 0.5, 0.5, 0.5, 0.5);
        }
    }

    protected List<ItemStack> doubleLoot(List<ItemStack> generatedLoot) {
        ArrayList<ItemStack> doubledLoot = new ArrayList<ItemStack>();
        for (ItemStack itemStack : generatedLoot) {
            boolean isItemForbidden = this.isForbidden(itemStack.func_77973_b());
            for (int i = 0; !(i >= 2 || i >= 1 && isItemForbidden); ++i) {
                doubledLoot.add(itemStack);
            }
        }
        return doubledLoot;
    }

    protected boolean isForbidden(Item item) {
        for (Item forbidden : this.forbiddenItemsToDuplicate) {
            if (!forbidden.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<DoubleLoot> {
        public DoubleLoot read(ResourceLocation name, JsonObject object, ILootCondition[] conditions) {
            double normalModeChance = JSONUtils.func_151217_k((JsonObject)object, (String)"normal_chance");
            double expertModeChance = JSONUtils.func_151217_k((JsonObject)object, (String)"expert_chance");
            double masterModeChance = JSONUtils.func_151217_k((JsonObject)object, (String)"master_chance");
            JsonArray items = JSONUtils.func_151214_t((JsonObject)object, (String)"forbidden_items");
            ArrayList<Item> forbiddenItemsToDuplicate = new ArrayList<Item>();
            for (int i = 0; i < items.size(); ++i) {
                JsonObject item = items.get(i).getAsJsonObject();
                forbiddenItemsToDuplicate.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.get("name").getAsString())));
            }
            return new DoubleLoot(conditions, normalModeChance, expertModeChance, masterModeChance, forbiddenItemsToDuplicate);
        }

        public JsonObject write(DoubleLoot instance) {
            return null;
        }
    }
}

