/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.world.feature.tree;

import com.maideniles.maidensmaterials.init.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class MaidensTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState DEFAULT_TRUNK = Blocks.field_196617_K.func_176223_P();
    private static final BlockState DEFAULT_LEAF = Blocks.field_196642_W.func_176223_P();
    private final boolean useExtraRandomHeight;
    private final BlockState trunk;
    private final BlockState leaf;

    public MaidensTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, boolean extraRandomHeightIn) {
        this(configFactoryIn, doBlockNotifyOnPlace, 4, true, DEFAULT_TRUNK, DEFAULT_LEAF);
    }

    public MaidensTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, int minTreeHeightIn, boolean extraRandomHeightIn, BlockState trunkState, BlockState leafState) {
        super(configFactoryIn, doBlockNotifyOnPlace);
        this.trunk = trunkState;
        this.leaf = leafState;
        this.useExtraRandomHeight = extraRandomHeightIn;
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int i = rand.nextInt(3) + 5;
        if (this.useExtraRandomHeight) {
            i += rand.nextInt(7);
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (MaidensTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (MaidensTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                for (int l1 = position.func_177956_o() - 3 + i; l1 <= position.func_177956_o() + i; ++l1) {
                    int j2 = l1 - (position.func_177956_o() + i);
                    int k2 = 1 - j2 / 2;
                    for (int l2 = position.func_177958_n() - k2; l2 <= position.func_177958_n() + k2; ++l2) {
                        int i3 = l2 - position.func_177958_n();
                        for (int j1 = position.func_177952_p() - k2; j1 <= position.func_177952_p() + k2; ++j1) {
                            BlockPos blockpos;
                            int k1 = j1 - position.func_177952_p();
                            if (Math.abs(i3) == k2 && Math.abs(k1) == k2 && (rand.nextInt(2) == 0 || j2 == 0) || !MaidensTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, blockpos = new BlockPos(l2, l1, j1))) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, blockpos, this.leaf, p_208519_5_);
                        }
                    }
                }
                for (int i2 = 0; i2 < i; ++i2) {
                    if (!MaidensTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, position.func_177981_b(i2))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(i2), this.trunk, p_208519_5_);
                }
                if (rand.nextInt(5) == 0 && i > 5) {
                    for (int k3 = 0; k3 < 2; ++k3) {
                        for (Direction direction : Direction.Plane.HORIZONTAL) {
                            if (rand.nextInt(4 - k3) != 0) continue;
                            Direction direction1 = direction.func_176734_d();
                            this.placeCocoa(worldIn, rand.nextInt(3), position.func_177982_a(direction1.func_82601_c(), i - 5 + k3, direction1.func_82599_e()), direction);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, BlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
    }

    protected static boolean isDirt(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214590_0_ -> Block.func_196245_f((Block)p_214590_0_.func_177230_c()));
    }

    protected static boolean isWater(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214583_0_ -> p_214583_0_.func_177230_c() == Blocks.field_150355_j);
    }

    protected static boolean isLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214579_0_ -> p_214579_0_.func_203425_a(BlockTags.field_206952_E));
    }

    protected static boolean isAirOrLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IWorldReader)) {
            return worldIn.func_217375_a(pos, p_214581_0_ -> p_214581_0_.func_196958_f() || p_214581_0_.func_203425_a(BlockTags.field_206952_E));
        }
        return worldIn.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)worldIn, pos));
    }

    @Deprecated
    protected static boolean isDirtOrGrassBlock(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214582_0_ -> {
            Block block = p_214582_0_.func_177230_c();
            return Block.func_196245_f((Block)block) || block == Blocks.field_196658_i || block == ModBlocks.ornamentalGrass.get() || block == ModBlocks.sparklingSand.get();
        });
    }

    protected static boolean isSoil(IWorldGenerationBaseReader reader, BlockPos pos, IPlantable sapling) {
        if (!(reader instanceof IBlockReader) || sapling == null) {
            return MaidensTreeFeature.isDirtOrGrassBlock(reader, pos);
        }
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, sapling));
    }

    @Deprecated
    protected static boolean isDirtOrGrassBlockOrFarmland(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214586_0_ -> {
            Block block = p_214586_0_.func_177230_c();
            return Block.func_196245_f((Block)block) || block == Blocks.field_196658_i || block == Blocks.field_150458_ak || block == ModBlocks.ornamentalGrass.get() || block == ModBlocks.sparklingSand.get();
        });
    }

    protected static boolean isSoilOrFarm(IWorldGenerationBaseReader reader, BlockPos pos, IPlantable sapling) {
        if (!(reader instanceof IBlockReader) || sapling == null) {
            return MaidensTreeFeature.isDirtOrGrassBlockOrFarmland(reader, pos);
        }
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, sapling));
    }

    protected static boolean func_214576_j(IWorldGenerationBaseReader p_214576_0_, BlockPos p_214576_1_) {
        return p_214576_0_.func_217375_a(p_214576_1_, p_214588_0_ -> {
            Material material = p_214588_0_.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    @Deprecated
    protected void func_214584_a(IWorldGenerationReader p_214584_1_, BlockPos p_214584_2_) {
        if (!MaidensTreeFeature.isDirt((IWorldGenerationBaseReader)p_214584_1_, p_214584_2_)) {
            this.func_202278_a((IWorldWriter)p_214584_1_, p_214584_2_, Blocks.field_150346_d.func_176223_P());
        }
    }

    private void placeCocoa(IWorldGenerationReader worldIn, int age, BlockPos pos, Direction side) {
        this.func_202278_a((IWorldWriter)worldIn, pos, (BlockState)((BlockState)((Block)ModBlocks.fairyGlowCup.get()).func_176223_P().func_206870_a((IProperty)CocoaBlock.field_176501_a, (Comparable)Integer.valueOf(age))).func_206870_a((IProperty)CocoaBlock.field_185512_D, (Comparable)side));
    }
}

