/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.world.feature.tree;

import com.maideniles.maidensmaterials.init.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class PalmTreeFeature1
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState DEFAULT_TRUNK = Blocks.field_196617_K.func_176223_P();
    private static final BlockState DEFAULT_LEAF = Blocks.field_196642_W.func_176223_P();
    private final boolean useExtraRandomHeight;
    private BlockState LOG;
    private BlockState LEAF;
    private final int minHeight = 5;
    public static final Random random = new Random();

    public PalmTreeFeature1(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, boolean extraRandomHeightIn) {
        this(configFactoryIn, doBlockNotifyOnPlace, 4, true, DEFAULT_TRUNK, DEFAULT_LEAF);
    }

    public PalmTreeFeature1(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, int minTreeHeightIn, boolean extraRandomHeightIn, BlockState trunkState, BlockState leafState) {
        super(configFactoryIn, doBlockNotifyOnPlace);
        this.LOG = trunkState;
        this.LEAF = leafState;
        this.useExtraRandomHeight = extraRandomHeightIn;
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random rand, BlockPos pos, MutableBoundingBox box) {
        int height = this.minHeight + rand.nextInt(4);
        int i = rand.nextInt(3) + 10;
        if (!this.ensureGrowable(world, pos, height)) {
            return false;
        }
        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        int xPos = pos.func_177958_n();
        int zPos = pos.func_177952_p();
        int top = 0;
        for (int block = 0; block <= height; ++block) {
            int yPos = pos.func_177956_o() + block;
            if (yPos > pos.func_177956_o() && yPos <= pos.func_177956_o() + (height - 3) && rand.nextInt(10) == 1) {
                xPos += direction.func_82601_c();
                zPos += direction.func_82599_e();
            }
            this.LOG = yPos == pos.func_177956_o() + height ? ((Block)ModBlocks.palmLog.get()).func_176223_P() : ((Block)ModBlocks.palmLog.get()).func_176223_P();
            BlockPos blockpos = new BlockPos(xPos, yPos, zPos);
            if (!PalmTreeFeature1.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)blockpos)) continue;
            this.placeLogAt(changedBlocks, (IWorldWriter)world, blockpos, box);
            top = yPos;
        }
        BlockPos topBlock = new BlockPos(xPos, top, zPos);
        this.placeLeafAt(changedBlocks, world, topBlock.func_177982_a(0, 1, 0), box);
        for (Direction side : Direction.Plane.HORIZONTAL) {
            this.leafLayer1(changedBlocks, world, topBlock, side, box);
        }
        return true;
    }

    private void leafLayer1(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos pos, Direction side, MutableBoundingBox box) {
        int k = -5;
        int i = -4;
        int j = -6;
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 0, j + 7, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 0, j + 8, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 1, j + 6, k + 2), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 1, j + 6, k + 8), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 1, j + 7, k + 2), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 1, j + 7, k + 8), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 1, j + 8, k + 2), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 1, j + 9, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 2, j + 8, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 2, j + 8, k + 7), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 2, j + 9, k + 3), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 2, j + 9, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 7, k + 4), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 7, k + 6), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 8, k + 4), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 8, k + 5), ((Block)ModBlocks.palmLog.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 8, k + 6), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 9, k + 4), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 9, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 9, k + 6), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 10, k + 4), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 10, k + 6), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 5, k + 0), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 5, k + 10), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 6, k + 0), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 6, k + 10), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 7, k + 1), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 7, k + 5), ((Block)ModBlocks.palmLog.get()).func_176223_P());
        if (random.nextInt(10) == 0) {
            this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 7, k + 5), ((Block)ModBlocks.coconutNut.get()).func_176223_P());
        }
        if (random.nextInt(10) == 0) {
            this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 7, k + 4), ((Block)ModBlocks.coconutNut.get()).func_176223_P());
        }
        if (random.nextInt(10) == 0) {
            this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 7, k + 5), ((Block)ModBlocks.coconutNut.get()).func_176223_P());
        }
        if (random.nextInt(10) == 0) {
            this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 7, k + 6), ((Block)ModBlocks.coconutNut.get()).func_176223_P());
        }
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 7, k + 9), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 8, k + 1), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 8, k + 3), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 8, k + 4), ((Block)ModBlocks.palmLog.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 8, k + 5), ((Block)ModBlocks.palmLog.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 8, k + 6), ((Block)ModBlocks.palmLog.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 8, k + 7), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 8, k + 9), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 9, k + 2), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 9, k + 3), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 9, k + 4), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 9, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 9, k + 6), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 9, k + 7), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 9, k + 8), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 10, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 7, k + 4), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 7, k + 6), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 8, k + 4), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 8, k + 5), ((Block)ModBlocks.palmLog.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 8, k + 6), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 9, k + 4), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 9, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 9, k + 6), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 10, k + 4), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 10, k + 6), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 6, j + 8, k + 3), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 6, j + 8, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 6, j + 9, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 6, j + 9, k + 7), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 7, j + 6, k + 2), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 7, j + 6, k + 8), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 7, j + 7, k + 2), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 7, j + 7, k + 8), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 7, j + 8, k + 8), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 7, j + 9, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 8, j + 7, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 8, j + 8, k + 5), ((Block)ModBlocks.palmLeaves.get()).func_176223_P());
    }

    private void placeLogAt(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, MutableBoundingBox box) {
        this.func_208520_a(changedBlocks, worldIn, pos, this.LOG, box);
    }

    private void placeLeafAt(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos pos, MutableBoundingBox box) {
        if (PalmTreeFeature1.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)pos)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, pos, this.LEAF, box);
        }
    }

    protected boolean ensureGrowable(IWorldGenerationReader worldIn, BlockPos treePos, int height) {
        return this.isSpaceAt(worldIn, treePos, height) && this.ensureViableBlockUnderneath(treePos, worldIn);
    }

    private boolean isSpaceAt(IWorldGenerationReader worldIn, BlockPos pos, int height) {
        boolean flag = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y >= 1 && y + height + 1 <= 256) {
            for (int yPos = y; yPos <= y + 1 + height; ++yPos) {
                int b0 = 1;
                if (yPos == y) {
                    b0 = 0;
                }
                if (yPos >= y + 1 + height - 2) {
                    b0 = 2;
                }
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (int xPos = x - b0; xPos <= x + b0 && flag; ++xPos) {
                    for (int zPos = z - b0; zPos <= z + b0 && flag; ++zPos) {
                        if (yPos >= 0 && yPos < 256) {
                            if (PalmTreeFeature1.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)mutable.func_181079_c(xPos, yPos, zPos))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean ensureViableBlockUnderneath(BlockPos pos, IWorldGenerationReader worldIn) {
        if (PalmTreeFeature1.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)pos.func_177977_b(), (IPlantable)this.getSapling()) || worldIn.func_217375_a(pos.func_177977_b(), state -> state.func_203425_a(BlockTags.field_203436_u))) {
            if (PalmTreeFeature1.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)pos.func_177977_b(), (IPlantable)this.getSapling())) {
                this.setDirtAt(worldIn, pos.func_177977_b(), pos);
            }
            return true;
        }
        return false;
    }

    private void placeCocoa(IWorldGenerationReader worldIn, int age, BlockPos pos, Direction side) {
        this.func_202278_a((IWorldWriter)worldIn, pos, (BlockState)((BlockState)((Block)ModBlocks.fairyGlowCup.get()).func_176223_P().func_206870_a((IProperty)CocoaBlock.field_176501_a, (Comparable)Integer.valueOf(age))).func_206870_a((IProperty)CocoaBlock.field_185512_D, (Comparable)side));
    }
}

