/*
 * Decompiled with CFR 0.152.
 */
package stevebeeblebrox.events;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.script.ScriptException;
import stevebeeblebrox.events.InvocableJSScriptEngine;

public class FileUtils {
    public static File getJarLocation() throws IOException {
        return new File(".").getCanonicalFile();
    }

    public static List<File> getAll(File directory, final String type) {
        return Arrays.asList(directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("." + type);
            }
        }));
    }

    public static List<File> getAll(File directory, String ... types) {
        ArrayList<File> list = new ArrayList<File>();
        for (String type : types) {
            list.addAll(FileUtils.getAll(directory, type));
        }
        return list;
    }

    public static void loadToEngine(InvocableJSScriptEngine engine, File source) throws ScriptException, IOException {
        try (FileReader fileReader = new FileReader(source);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            engine.eval(bufferedReader);
        }
    }

    public static void loadAllToEngine(InvocableJSScriptEngine engine, File directory, String ... types) throws ScriptException, IOException {
        for (File file : FileUtils.getAll(directory, types)) {
            FileUtils.loadToEngine(engine, file);
        }
    }
}

