/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukegrahamlandry.mimic.entities;

import io.github.lukegrahamlandry.mimic.MimicMain;
import io.github.lukegrahamlandry.mimic.client.MimicContainer;
import io.github.lukegrahamlandry.mimic.goals.EatChestGoal;
import io.github.lukegrahamlandry.mimic.goals.FindChestGoal;
import io.github.lukegrahamlandry.mimic.goals.LockedPanicGoal;
import io.github.lukegrahamlandry.mimic.goals.MimicAttackGoal;
import io.github.lukegrahamlandry.mimic.goals.MimicChaseGoal;
import io.github.lukegrahamlandry.mimic.goals.MimicWanderGoal;
import io.github.lukegrahamlandry.mimic.goals.TamedFollowGoal;
import io.github.lukegrahamlandry.mimic.init.ContainerInit;
import io.github.lukegrahamlandry.mimic.init.ItemInit;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MimicEntity
extends CreatureEntity
implements IAnimatable,
INamedContainerProvider,
IInventory {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final DataParameter<Boolean> IS_TAMED = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_STEALTH = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_LOCKED = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_ANGRY = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> UP_DOWN_TICK = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_OPEN = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> OPEN_CLOSE_TICK = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FACING_DIRECTION = EntityDataManager.func_187226_a(MimicEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private UUID owner;
    int playerLookTicks = 0;
    PlayerEntity playerLooking;
    int scaredTicks = 0;
    boolean hasAlreadyGeneratedLoot = false;
    private NonNullList<ItemStack> heldItems = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private static final int boredOfWanderingChance = 2400;

    public MimicEntity(EntityType<? extends MimicEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return AttributeModifierMap.func_233803_a_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233823_f_, 14.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.55).func_233814_a_(Attributes.field_233826_i_).func_233814_a_(Attributes.field_233827_j_).func_233814_a_((Attribute)ForgeMod.SWIM_SPEED.get()).func_233814_a_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()).func_233814_a_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233814_a_(Attributes.field_233824_g_);
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new MimicChaseGoal(this, 0.6, 10));
        this.field_70714_bg.func_75776_a(2, (Goal)new MimicAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new EatChestGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FindChestGoal(this, 0.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new LockedPanicGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(6, (Goal)new TamedFollowGoal(this, 0.5, 8.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new MimicWanderGoal(this, 0.5));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d()) {
            if (this.getAttackTick() > 0) {
                this.func_184212_Q().func_187227_b(ATTACK_TICK, (Object)(this.getAttackTick() - 1));
            }
            if ((Integer)this.func_184212_Q().func_187225_a(UP_DOWN_TICK) > 0) {
                this.func_184212_Q().func_187227_b(UP_DOWN_TICK, (Object)((Integer)this.func_184212_Q().func_187225_a(UP_DOWN_TICK) - 1));
            }
            if ((Integer)this.func_184212_Q().func_187225_a(OPEN_CLOSE_TICK) > 0) {
                this.func_184212_Q().func_187227_b(OPEN_CLOSE_TICK, (Object)((Integer)this.func_184212_Q().func_187225_a(OPEN_CLOSE_TICK) - 1));
            }
            if (this.scaredTicks > 0) {
                --this.scaredTicks;
            }
            if (this.playerLookTicks > 0) {
                --this.playerLookTicks;
                if (this.playerLookTicks == 0 && !this.isLocked() && !this.isTamed()) {
                    this.playerLooking.func_71053_j();
                    this.setAngry(true);
                    float strength = 1.0f;
                    this.playerLooking.func_233627_a_(strength * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                }
            }
            if (!(this.isAngry() || this.isStealth() || this.isTamed() || this.func_70681_au().nextInt(2400) != 0)) {
                this.snapToBlock(this.func_233580_cy_(), Direction.func_176731_b((int)Math.floorDiv((int)this.field_70761_aq, 90)));
                this.setStealth(true);
                MimicMain.LOGGER.debug("mimic got board of searching and sat down");
            }
            if (!(this.isAngry() || this.isStealth() || this.isTamed() || this.isLocked() || this.func_70681_au().nextInt(5) != 0)) {
                AxisAlignedBB box = this.func_174813_aQ().func_186662_g(10.0);
                for (PlayerEntity playerentity : this.field_70170_p.func_217369_A()) {
                    if (playerentity.func_184812_l_() || !box.func_197744_e(playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_())) continue;
                    this.snapToBlock(this.func_233580_cy_(), null);
                    this.setStealth(true);
                }
            }
        }
    }

    public void snapToBlock(BlockPos pos, @Nullable Direction dir) {
        if (dir == null) {
            dir = Direction.func_176731_b((int)this.func_70681_au().nextInt(4));
        }
        MimicMain.LOGGER.debug("snaped facing " + dir.func_176742_j());
        this.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, dir.func_176736_b() * 90, 0.0f);
        this.func_181013_g(dir.func_176736_b() * 90);
        this.func_70661_as().func_75484_a((Path)null, 0.0);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getAttackTick() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.attack", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (this.isOpen()) {
            if (this.isLocked()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.locked.mimic.chest.open", Boolean.valueOf(false)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.chest.open", Boolean.valueOf(false)));
            }
            return PlayState.CONTINUE;
        }
        if ((Integer)this.func_184212_Q().func_187225_a(OPEN_CLOSE_TICK) > 0) {
            if (this.isLocked()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.locked.mimic.chest.close", Boolean.valueOf(false)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.chest.close", Boolean.valueOf(false)));
            }
            return PlayState.CONTINUE;
        }
        if (this.isLocked() && ((Boolean)this.func_184212_Q().func_187225_a(IS_STEALTH)).booleanValue()) {
            if ((Integer)this.func_184212_Q().func_187225_a(UP_DOWN_TICK) > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.lock", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.lockidle", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.isLocked() && (Integer)this.func_184212_Q().func_187225_a(UP_DOWN_TICK) > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.locked.mimic.getup", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.func_184212_Q().func_187225_a(IS_STEALTH)).booleanValue()) {
            if ((Integer)this.func_184212_Q().func_187225_a(UP_DOWN_TICK) > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.sit", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.idle.chest", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if ((Integer)this.func_184212_Q().func_187225_a(UP_DOWN_TICK) > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.getup", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            if (this.isLocked()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.locked.mimic.run", Boolean.valueOf(true)));
            } else if (this.isAngry()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.run", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.walkcycle", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        if (this.isLocked()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.locked.mimic.idle", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mimic.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ATTACK_TICK, (Object)0);
        this.func_184212_Q().func_187214_a(UP_DOWN_TICK, (Object)0);
        this.func_184212_Q().func_187214_a(IS_TAMED, (Object)false);
        this.func_184212_Q().func_187214_a(IS_LOCKED, (Object)false);
        this.func_184212_Q().func_187214_a(IS_ANGRY, (Object)false);
        this.func_184212_Q().func_187214_a(IS_STEALTH, (Object)false);
        this.func_184212_Q().func_187214_a(IS_OPEN, (Object)false);
        this.func_184212_Q().func_187214_a(OPEN_CLOSE_TICK, (Object)0);
        this.func_184212_Q().func_187214_a(FACING_DIRECTION, (Object)-1);
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        if (this.isTamed() && player.func_225608_bj_() && !this.field_70170_p.func_201670_d()) {
            boolean targetState = !this.isStealth();
            this.setStealth(targetState);
            if (targetState) {
                this.snapToBlock(this.func_233580_cy_(), Direction.func_176731_b((int)Math.floorDiv((int)this.field_70761_aq, 90)));
            }
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ItemInit.MIMIC_LOCK.get() && !this.isTamed()) {
            this.setLocked(true);
            this.snapToBlock(this.func_233580_cy_(), Direction.func_176731_b((int)Math.floorDiv((int)this.field_70761_aq, 90)));
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.func_70661_as().func_75484_a((Path)null, 0.0);
            return ActionResultType.CONSUME;
        }
        if (stack.func_77973_b() == ItemInit.MIMIC_KEY.get() && !this.isTamed()) {
            if (!this.field_70170_p.func_201670_d()) {
                this.setTamed(true);
                this.setStealth(true);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                this.owner = player.func_110124_au();
                this.func_70661_as().func_75484_a((Path)null, 0.0);
            } else {
                MimicMain.LOGGER.debug("particles");
                this.spawnTamingParticles();
            }
            return ActionResultType.CONSUME;
        }
        if (this.isStealth() && !player.func_225608_bj_()) {
            if (this.func_191420_l()) {
                this.generateDefaultLoot();
            }
            player.func_213829_a((INamedContainerProvider)this);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.func_213333_a(p_213333_1_, p_213333_2_, p_213333_3_);
        if (this.func_191420_l()) {
            this.generateDefaultLoot();
        }
        for (int i = 0; i < this.heldItems.size(); ++i) {
            if (((ItemStack)this.heldItems.get(i)).func_77973_b() == Items.field_190931_a) continue;
            this.func_199701_a_((ItemStack)this.heldItems.get(i));
        }
    }

    public void addItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        this.hasAlreadyGeneratedLoot = true;
        for (int i = 0; i < this.heldItems.size(); ++i) {
            if (((ItemStack)this.heldItems.get(i)).func_77973_b() != Items.field_190931_a) continue;
            this.heldItems.set(i, (Object)stack);
            this.func_110163_bv();
            return;
        }
        ItemEntity item = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
        this.field_70170_p.func_217376_c((Entity)item);
    }

    private void generateDefaultLoot() {
        if (this.field_70170_p.func_201670_d() || this.hasAlreadyGeneratedLoot) {
            return;
        }
        ResourceLocation lootLocation = new ResourceLocation("mimic", "default_mimic_loot");
        LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(lootLocation);
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch());
        loottable.func_216118_a((IInventory)this, lootcontext$builder.func_216022_a(LootParameterSets.field_216261_b));
        this.hasAlreadyGeneratedLoot = true;
    }

    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        CompoundNBT nbt = new CompoundNBT();
        for (int i = 0; i < this.heldItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.heldItems.get(i);
            CompoundNBT tag = stack.func_77955_b(new CompoundNBT());
            nbt.func_218657_a(String.valueOf(i), (INBT)tag);
        }
        compoundNBT.func_218657_a("mimichelditems", (INBT)nbt);
        compoundNBT.func_74757_a("tame", this.isTamed());
        compoundNBT.func_74757_a("lock", this.isLocked());
        compoundNBT.func_74757_a("angry", this.isAngry());
        compoundNBT.func_74757_a("stealth", this.isStealth());
        compoundNBT.func_74757_a("genloot", this.hasAlreadyGeneratedLoot);
        if (this.isTamed()) {
            compoundNBT.func_74778_a("owner", this.owner.toString());
        }
    }

    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        CompoundNBT nbt = compoundNBT.func_74775_l("mimichelditems");
        int i = 0;
        while (nbt.func_74764_b(String.valueOf(i))) {
            CompoundNBT tag = nbt.func_74775_l(String.valueOf(i));
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag);
            this.heldItems.set(i, (Object)stack);
            ++i;
        }
        this.setTamed(compoundNBT.func_74767_n("tame"));
        this.setLocked(compoundNBT.func_74767_n("lock"));
        this.setStealth(compoundNBT.func_74767_n("stealth"));
        this.setAngry(compoundNBT.func_74767_n("angry"));
        this.hasAlreadyGeneratedLoot = compoundNBT.func_74767_n("genloot");
        if (this.isTamed()) {
            this.owner = UUID.fromString(compoundNBT.func_74779_i("owner"));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76364_f() != null && source.func_76364_f() instanceof LivingEntity && ((LivingEntity)source.func_76364_f()).func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof AxeItem) {
            amount *= 2.0f;
        }
        if (!this.field_70170_p.func_201670_d() && source.func_76364_f() != null && source.func_76364_f() instanceof PlayerEntity && !((PlayerEntity)source.func_76364_f()).func_184812_l_()) {
            this.setAngry(true);
        }
        return super.func_70097_a(source, amount);
    }

    public LivingEntity getOwner() {
        if (!this.isTamed() || this.field_70170_p.func_201670_d()) {
            return null;
        }
        return (LivingEntity)((ServerWorld)this.field_70170_p).func_217461_a(this.owner);
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70108_f(Entity p_70108_1_) {
    }

    public void func_70024_g(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    public boolean isScared() {
        return this.scaredTicks > 0;
    }

    public boolean isOpen() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_OPEN);
    }

    public boolean isTamed() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_TAMED);
    }

    public boolean isAngry() {
        boolean flag = (Boolean)this.func_184212_Q().func_187225_a(IS_ANGRY);
        if (flag && this.isStealth()) {
            return false;
        }
        return flag;
    }

    public boolean isStealth() {
        boolean flag = (Boolean)this.func_184212_Q().func_187225_a(IS_STEALTH);
        if (!flag && (Integer)this.func_184212_Q().func_187225_a(UP_DOWN_TICK) > 0) {
            return true;
        }
        return flag;
    }

    public boolean isLocked() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_LOCKED);
    }

    public boolean hasTarget() {
        return this.func_70638_az() != null && this.func_70638_az().func_70089_S();
    }

    public int getAttackTick() {
        return (Integer)this.func_184212_Q().func_187225_a(ATTACK_TICK);
    }

    public void startAttackAnim() {
        this.func_184212_Q().func_187227_b(ATTACK_TICK, (Object)20);
    }

    public void setAngry(boolean flag) {
        if (flag) {
            this.setStealth(false);
            if (this.isTamed() || this.isLocked()) {
                return;
            }
        }
        this.func_184212_Q().func_187227_b(IS_ANGRY, (Object)flag);
    }

    public void setStealth(boolean flag) {
        if (!this.isStealth() && flag) {
            this.func_184212_Q().func_187227_b(UP_DOWN_TICK, (Object)20);
        } else if (this.isStealth() && !flag) {
            this.func_184212_Q().func_187227_b(UP_DOWN_TICK, (Object)22);
        }
        this.func_184212_Q().func_187227_b(IS_STEALTH, (Object)flag);
        MimicMain.LOGGER.debug("stealth: " + flag);
    }

    public void setLocked(boolean flag) {
        if (!this.isLocked() && flag) {
            this.func_184212_Q().func_187227_b(UP_DOWN_TICK, (Object)28);
        }
        if (flag) {
            this.setAngry(false);
            this.setStealth(true);
        }
        this.func_184212_Q().func_187227_b(IS_LOCKED, (Object)flag);
    }

    public void setTamed(boolean flag) {
        if (flag) {
            this.setAngry(false);
        }
        this.func_184212_Q().func_187227_b(IS_TAMED, (Object)flag);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "moveController", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        if (this.isTamed()) {
            return new MimicContainer((ContainerType)ContainerInit.TAME_MIMIC.get(), id, playerInventory, this, 3);
        }
        this.playerLooking = player;
        this.playerLookTicks = 15;
        return new MimicContainer((ContainerType)ContainerInit.EVIL_MIMIC.get(), id, playerInventory, this, 3);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void spawnTamingParticles() {
        BasicParticleType iparticledata = ParticleTypes.field_197633_z;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)iparticledata, this.func_226282_d_(1.0), this.func_226279_cv_() + 2.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    public void func_174886_c(PlayerEntity p_174886_1_) {
        this.func_184212_Q().func_187227_b(OPEN_CLOSE_TICK, (Object)10);
        this.func_184212_Q().func_187227_b(IS_OPEN, (Object)false);
        MimicMain.LOGGER.debug("stop open");
    }

    public void func_174889_b(PlayerEntity p_174889_1_) {
        this.func_184212_Q().func_187227_b(OPEN_CLOSE_TICK, (Object)13);
        this.func_184212_Q().func_187227_b(IS_OPEN, (Object)true);
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        return this.heldItems.stream().allMatch(ItemStack::func_190926_b);
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.heldItems.get(index);
    }

    private void onTake() {
        this.playerLookTicks = 2;
        MimicMain.LOGGER.debug("take item");
        if (this.isLocked() && this.func_70681_au().nextInt(3) == 0) {
            this.playerLooking.func_71053_j();
            this.scaredTicks = 400;
            this.setStealth(false);
        }
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.heldItems, (int)p_70298_1_, (int)p_70298_2_);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
            this.onTake();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        ItemStack itemstack = ItemStackHelper.func_188383_a(this.heldItems, (int)p_70304_1_);
        if (!itemstack.func_190926_b()) {
            this.onTake();
        }
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.heldItems.set(index, (Object)stack);
        if (stack.func_190926_b()) {
            this.onTake();
        }
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        return this.func_70089_S();
    }

    public void func_174888_l() {
        this.heldItems.clear();
    }

    public static <T extends MobEntity> boolean checkSpawn(EntityType<T> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        if (world.func_180495_p(pos).func_203425_a(Blocks.field_201941_jj)) {
            MimicMain.LOGGER.debug("spawn mimic at " + pos);
            return true;
        }
        return false;
    }
}

