/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukegrahamlandry.mimic.events;

import io.github.lukegrahamlandry.mimic.MimicMain;
import io.github.lukegrahamlandry.mimic.entities.MimicEntity;
import io.github.lukegrahamlandry.mimic.init.EntityInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mimic", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TickHandler {
    public static List<MimicSpawnData> spawns = new ArrayList<MimicSpawnData>();

    @SubscribeEvent
    public static void loadBiome(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (MimicSpawnData spawn : spawns) {
                --spawn.time;
                if (spawn.time > 0) continue;
                TickHandler.spawnMimic(spawn);
                spawns.remove(spawn);
                MimicMain.LOGGER.debug(spawns);
                return;
            }
        }
    }

    private static void spawnMimic(MimicSpawnData spawn) {
        MimicMain.LOGGER.debug("try spawn mimic");
        BlockState state = spawn.world.func_180495_p(spawn.pos);
        if (state.func_203425_a(Blocks.field_150486_ae)) {
            ChestTileEntity chest = (ChestTileEntity)spawn.world.func_175625_s(spawn.pos);
            MimicEntity mimic = new MimicEntity((EntityType<? extends MimicEntity>)((EntityType)EntityInit.MIMIC.get()), spawn.world);
            for (int i = 0; i < chest.func_70302_i_(); ++i) {
                mimic.addItem(chest.func_70301_a(i));
                chest.func_70299_a(i, ItemStack.field_190927_a);
            }
            spawn.world.func_180501_a(spawn.pos, Blocks.field_150350_a.func_176223_P(), 3);
            mimic.snapToBlock(spawn.pos, (Direction)state.func_177229_b((Property)ChestBlock.field_176459_a));
            mimic.setStealth(true);
            spawn.world.func_217376_c((Entity)mimic);
        }
    }

    public static class MimicSpawnData {
        public final BlockPos pos;
        public int time;
        public final World world;

        public MimicSpawnData(World level, BlockPos position) {
            this.pos = position;
            this.time = 40;
            this.world = level;
        }
    }
}

