/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukegrahamlandry.mimic.goals;

import io.github.lukegrahamlandry.mimic.entities.MimicEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class LockedPanicGoal
extends Goal {
    protected final MimicEntity mob;
    protected final double speedModifier;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected boolean isRunning;

    public LockedPanicGoal(MimicEntity p_i1645_1_, double p_i1645_2_) {
        this.mob = p_i1645_1_;
        this.speedModifier = p_i1645_2_;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        BlockPos blockpos;
        if (!this.mob.isLocked() || this.mob.isStealth()) {
            return false;
        }
        if (!this.mob.isScared() && this.mob.func_70643_av() == null && !this.mob.func_70027_ad()) {
            return false;
        }
        if (this.mob.func_70027_ad() && (blockpos = this.lookForWater((IBlockReader)this.mob.field_70170_p, (Entity)this.mob, 5, 4)) != null) {
            this.posX = blockpos.func_177958_n();
            this.posY = blockpos.func_177956_o();
            this.posZ = blockpos.func_177952_p();
            return true;
        }
        return this.findRandomPosition();
    }

    protected boolean findRandomPosition() {
        Vector3d vector3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.mob, (int)5, (int)4);
        if (vector3d == null) {
            return false;
        }
        this.posX = vector3d.field_72450_a;
        this.posY = vector3d.field_72448_b;
        this.posZ = vector3d.field_72449_c;
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void func_75249_e() {
        this.mob.func_70661_as().func_75492_a(this.posX, this.posY, this.posZ, this.speedModifier);
        this.isRunning = true;
        this.mob.setStealth(false);
    }

    public void func_75251_c() {
        this.isRunning = false;
    }

    public boolean func_75253_b() {
        return !this.mob.func_70661_as().func_75500_f();
    }

    @Nullable
    protected BlockPos lookForWater(IBlockReader p_188497_1_, Entity p_188497_2_, int p_188497_3_, int p_188497_4_) {
        BlockPos blockpos = p_188497_2_.func_233580_cy_();
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177956_o();
        int k = blockpos.func_177952_p();
        float f = p_188497_3_ * p_188497_3_ * p_188497_4_ * 2;
        BlockPos blockpos1 = null;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l = i - p_188497_3_; l <= i + p_188497_3_; ++l) {
            for (int i1 = j - p_188497_4_; i1 <= j + p_188497_4_; ++i1) {
                for (int j1 = k - p_188497_3_; j1 <= k + p_188497_3_; ++j1) {
                    float f1;
                    blockpos$mutable.func_181079_c(l, i1, j1);
                    if (!p_188497_1_.func_204610_c((BlockPos)blockpos$mutable).func_206884_a((ITag)FluidTags.field_206959_a) || !((f1 = (float)((l - i) * (l - i) + (i1 - j) * (i1 - j) + (j1 - k) * (j1 - k))) < f)) continue;
                    f = f1;
                    blockpos1 = new BlockPos((Vector3i)blockpos$mutable);
                }
            }
        }
        return blockpos1;
    }
}

