/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import flash.minechess.client.gui.screen.BoardScreen;
import flash.minechess.client.gui.widget.ColorPickerWidget;
import flash.minechess.client.gui.widget.ColorSquareWidget;
import flash.minechess.client.gui.widget.HueSliderWidget;
import flash.minechess.main.Main;
import flash.minechess.util.ColorUtil;
import flash.minechess.util.chess.BoardRepresentation;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorPickerScreen
extends Screen {
    ColorPickerWidget colorPickerWidget;
    HueSliderWidget hueSliderWidget;
    ColorSquareWidget[] squares = new ColorSquareWidget[16];
    public static int whiteColor = -1;
    public static int blackColor = -16777216;
    public static int highlightedColor = -3190;
    private int currentlyEditing = 0;

    public ColorPickerScreen() {
        super((ITextComponent)new TranslationTextComponent(Main.getScreenName("colorpicker")));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int editButtonX = this.field_230708_k_ / 4 + 40;
        int n = this.field_230709_l_ / 2 + 60 + 10;
        this.field_230712_o_.getClass();
        int editButtonY = n - 9 / 2;
        ColorPickerScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent(Main.getScreenName("color.edit" + this.currentlyEditing)), (int)editButtonX, (int)editButtonY, (int)0xFFFFFF);
    }

    protected void func_231160_c_() {
        int w = 150;
        int h = 150;
        int x = this.field_230708_k_ / 4 * 3 - w / 2;
        int y = this.field_230709_l_ / 2 - h / 2;
        this.colorPickerWidget = (ColorPickerWidget)this.func_230480_a_((Widget)new ColorPickerWidget(x, y, w, h));
        this.hueSliderWidget = (HueSliderWidget)this.func_230480_a_((Widget)new HueSliderWidget(x + w + 10, y, 20, h));
        int squareX = this.field_230708_k_ / 4;
        int squareY = this.field_230709_l_ / 2 - 40;
        for (int i = 0; i < this.squares.length; ++i) {
            int x1 = i >> 2;
            int y1 = i & 3;
            this.squares[i] = (ColorSquareWidget)this.func_230480_a_((Widget)new ColorSquareWidget(squareX + y1 * 20, squareY + x1 * 20, BoardRepresentation.lightSquare(y1, x1), y1, x1));
        }
        this.squares[0].setPiece(22);
        this.squares[1].setPiece(17);
        this.squares[2].setPiece(23);
        this.squares[3].setPiece(18);
        this.squares[12].setPiece(14);
        this.squares[13].setPiece(9);
        this.squares[14].setPiece(15);
        this.squares[15].setPiece(10);
        this.squares[3].setHighlighted(true);
        this.squares[7].setHighlighted(true);
        this.squares[11].setHighlighted(true);
        this.squares[15].setHighlighted(true);
        this.func_230480_a_((Widget)new Button(squareX, squareY + 100, 80, 20, StringTextComponent.field_240750_d_, press -> {
            if (this.currentlyEditing == 0 || this.currentlyEditing == 3) {
                this.colorPickerWidget.setHueColor(whiteColor);
                this.colorPickerWidget.setSelectedColor(whiteColor);
                this.hueSliderWidget.setHueColor(whiteColor);
                this.currentlyEditing = 1;
            } else if (this.currentlyEditing == 1) {
                this.colorPickerWidget.setHueColor(blackColor);
                this.colorPickerWidget.setSelectedColor(blackColor);
                this.hueSliderWidget.setHueColor(blackColor);
                this.currentlyEditing = 2;
            } else {
                this.colorPickerWidget.setHueColor(highlightedColor);
                this.colorPickerWidget.setSelectedColor(highlightedColor);
                this.hueSliderWidget.setHueColor(highlightedColor);
                this.currentlyEditing = 3;
            }
        }));
        this.func_230480_a_((Widget)new Button(squareX, squareY - 40, 80, 20, (ITextComponent)new TranslationTextComponent(Main.getScreenName("color.save")), press -> {
            ColorUtil.save(whiteColor, blackColor, highlightedColor);
            BoardScreen.whiteColor = whiteColor;
            BoardScreen.blackColor = blackColor;
            BoardScreen.highlightedColor = highlightedColor;
            this.func_231175_as__();
        }));
    }

    public void func_231023_e_() {
        int sliderHue = this.hueSliderWidget.getHueColor();
        if (this.colorPickerWidget.getHueColor() != sliderHue) {
            this.colorPickerWidget.setHueColor(this.hueSliderWidget.getHueColor());
            this.colorPickerWidget.getColorAtMarker();
        }
        if (this.currentlyEditing == 1 && whiteColor != this.colorPickerWidget.getSelectedColor()) {
            whiteColor = this.colorPickerWidget.getSelectedColor();
        }
        if (this.currentlyEditing == 2 && blackColor != this.colorPickerWidget.getSelectedColor()) {
            blackColor = this.colorPickerWidget.getSelectedColor();
        }
        if (this.currentlyEditing == 3 && highlightedColor != this.colorPickerWidget.getSelectedColor()) {
            highlightedColor = this.colorPickerWidget.getSelectedColor();
        }
    }
}

