/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import flash.minechess.commands.Command;
import flash.minechess.main.Main;
import flash.minechess.util.Challenge;
import flash.minechess.util.ChallengeUtil;
import flash.minechess.util.MatchUtil;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ChallengeCommand
extends Command {
    @Override
    public String getName() {
        return "challenge";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"c").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(src -> this.challengePlayer((CommandSource)src.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)src, (String)"player")))));
        builder.then(Commands.func_197057_a((String)"accept").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(src -> this.acceptChallenge((CommandSource)src.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)src, (String)"player")))));
    }

    private int challengePlayer(CommandSource src, PlayerEntity player) throws CommandSyntaxException {
        UUID blackPlayer;
        UUID whitePlayer = src.func_197035_h().func_110124_au();
        if (whitePlayer.equals(blackPlayer = player.func_110124_au())) {
            src.func_197035_h().func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.self")).func_240699_a_(TextFormatting.RED), false);
        } else if (MatchUtil.findMatch(blackPlayer) != null) {
            src.func_197035_h().func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.inmatch"), new Object[]{player.func_195047_I_()}).func_240699_a_(TextFormatting.RED), false);
        } else {
            Challenge challenge = new Challenge(whitePlayer, blackPlayer);
            if (!ChallengeUtil.challengeList.contains(challenge)) {
                ChallengeUtil.newChallenge(whitePlayer, blackPlayer);
                src.func_197035_h().func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.sent"), new Object[]{player.func_195047_I_()}).func_240699_a_(TextFormatting.GREEN), false);
                player.func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.received"), new Object[]{src.func_197035_h().func_195047_I_()}).func_240699_a_(TextFormatting.GREEN), false);
            } else {
                src.func_197035_h().func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.alreadysent")).func_240699_a_(TextFormatting.RED), false);
            }
        }
        return 1;
    }

    private int acceptChallenge(CommandSource src, PlayerEntity player) throws CommandSyntaxException {
        UUID blackPlayer = src.func_197035_h().func_110124_au();
        UUID whitePlayer = player.func_110124_au();
        Challenge challenge = ChallengeUtil.findChallenge(whitePlayer, blackPlayer);
        if (challenge != null) {
            src.func_197035_h().func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.accept.self"), new Object[]{player.func_195047_I_()}).func_240699_a_(TextFormatting.GREEN), false);
            challenge.accept();
        } else {
            src.func_197035_h().func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.accept.none"), new Object[]{player.func_195047_I_()}).func_240699_a_(TextFormatting.RED), false);
        }
        return 1;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

