/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import flash.minechess.commands.Command;
import flash.minechess.main.Main;
import flash.minechess.network.PacketDispatcher;
import flash.minechess.network.receive_client.PacketResignMatch;
import flash.minechess.util.Match;
import flash.minechess.util.MatchUtil;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ResignCommand
extends Command {
    @Override
    public String getName() {
        return "resign";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(src -> this.resign((CommandSource)src.getSource()));
    }

    private int resign(CommandSource src) throws CommandSyntaxException {
        Match match = MatchUtil.findMatch(src.func_197035_h().func_110124_au());
        if (match != null) {
            match.resign(src.func_197035_h().func_110124_au());
            match.notifyResign();
            PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
            ServerPlayerEntity white = playerList.func_177451_a(match.getWhitePlayer());
            ServerPlayerEntity black = playerList.func_177451_a(match.getBlackPlayer());
            if (white != null) {
                PacketDispatcher.sendTo(new PacketResignMatch(src.func_197035_h().func_110124_au()), (PlayerEntity)white);
            }
            if (black != null) {
                PacketDispatcher.sendTo(new PacketResignMatch(src.func_197035_h().func_110124_au()), (PlayerEntity)black);
            }
            MatchUtil.finishMatch(match.getWhitePlayer(), match.getBlackPlayer());
        } else {
            src.func_197035_h().func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("matches.none")).func_240699_a_(TextFormatting.RED), false);
        }
        return 1;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

