/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.events;

import flash.minechess.network.PacketDispatcher;
import flash.minechess.network.receive_client.PacketSyncMatch;
import flash.minechess.util.Challenge;
import flash.minechess.util.ChallengeUtil;
import flash.minechess.util.Match;
import flash.minechess.util.MatchUtil;
import flash.minechess.util.chess.Move;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

public class EventHandler {
    @SubscribeEvent
    public void serverShutdown(FMLServerStoppingEvent event) {
        MatchUtil.saveMatches();
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent event) {
        ArrayList<Challenge> toRemove = new ArrayList<Challenge>();
        for (Challenge challenge : ChallengeUtil.challengeList) {
            challenge.tick();
            if (challenge.getTick() > 0 && MatchUtil.findMatch(challenge.getWhitePlayer()) == null && MatchUtil.findMatch(challenge.getBlackPlayer()) == null) continue;
            toRemove.add(challenge);
        }
        for (Challenge challenge : toRemove) {
            challenge.deny();
        }
    }

    @SubscribeEvent
    public void playerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Match match;
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K && (match = MatchUtil.findMatch(player.func_110124_au())) != null) {
            Move lastMove = match.getBoard().lastMadeMove;
            if (lastMove == null) {
                PacketDispatcher.sendTo(new PacketSyncMatch(match), player);
            } else {
                PacketDispatcher.sendTo(new PacketSyncMatch(match, lastMove), player);
            }
        }
    }
}

