/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util;

import flash.minechess.main.Main;
import flash.minechess.network.PacketDispatcher;
import flash.minechess.network.receive_client.PacketStartMatch;
import flash.minechess.util.ChallengeUtil;
import flash.minechess.util.MatchUtil;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class Challenge {
    private UUID whitePlayer;
    private UUID blackPlayer;
    private int tick;

    public Challenge(UUID whitePlayer, UUID blackPlayer) {
        this.whitePlayer = whitePlayer;
        this.blackPlayer = blackPlayer;
        this.tick = 1200;
    }

    public UUID getWhitePlayer() {
        return this.whitePlayer;
    }

    public UUID getBlackPlayer() {
        return this.blackPlayer;
    }

    public void accept() {
        MatchUtil.newMatch(this.whitePlayer, this.blackPlayer);
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
        ServerPlayerEntity white = playerList.func_177451_a(this.whitePlayer);
        ServerPlayerEntity black = playerList.func_177451_a(this.blackPlayer);
        if (white != null) {
            PacketDispatcher.sendTo(new PacketStartMatch(this.whitePlayer, this.blackPlayer), (PlayerEntity)white);
            if (black != null) {
                PacketDispatcher.sendTo(new PacketStartMatch(this.whitePlayer, this.blackPlayer), (PlayerEntity)black);
                white.func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.accept"), new Object[]{black.func_195047_I_()}).func_240699_a_(TextFormatting.GREEN), false);
            }
        }
        ChallengeUtil.removeChallenge(this);
    }

    public void deny() {
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
        ServerPlayerEntity white = playerList.func_177451_a(this.whitePlayer);
        ServerPlayerEntity black = playerList.func_177451_a(this.blackPlayer);
        if (black != null) {
            black.func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.deny.self"), new Object[]{white.func_195047_I_()}).func_240699_a_(TextFormatting.RED), false);
            if (white != null) {
                white.func_146105_b((ITextComponent)new TranslationTextComponent(Main.getMessageName("challenge.deny"), new Object[]{black.func_195047_I_()}).func_240699_a_(TextFormatting.RED), false);
            }
        }
        ChallengeUtil.removeChallenge(this);
    }

    public void tick() {
        --this.tick;
    }

    public int getTick() {
        return this.tick;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Challenge challenge = (Challenge)o;
        return this.whitePlayer.equals(challenge.whitePlayer) && this.blackPlayer.equals(challenge.blackPlayer);
    }
}

