/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class ScreenHelper {
    public static int colorLightness(int color, int amount) {
        int r = (int)ScreenHelper.clamp(((color & 0xFF0000) >> 16) + amount, 0.0f, 255.0f);
        int g = (int)ScreenHelper.clamp(((color & 0xFF00) >> 8) + amount, 0.0f, 255.0f);
        int b = (int)ScreenHelper.clamp((color & 0xFF) + amount, 0.0f, 255.0f);
        int newColor = 0xFF000000 | r << 16 | g << 8 | b;
        return newColor;
    }

    public static float clamp(float value, float minValue, float maxValue) {
        return value < minValue ? minValue : (value > maxValue ? maxValue : value);
    }

    public static void fillGradient(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int color) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        ScreenHelper.fillGradient(matrixStack.func_227866_c_().func_227870_a_(), bufferbuilder, x1, y1, x2, y2, 0, color);
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int z, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        builder.func_227888_a_(matrix, (float)x2, (float)y1, (float)z).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y1, (float)z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, (float)x1, (float)y2, (float)z).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, (float)x2, (float)y2, (float)z).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
    }
}

