/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util.chess;

import flash.minechess.util.chess.BoardRepresentation;
import flash.minechess.util.chess.FenUtility;
import flash.minechess.util.chess.Move;
import flash.minechess.util.chess.Piece;
import flash.minechess.util.chess.PieceList;

public class Board {
    public static final int whiteIndex = 0;
    public static final int blackIndex = 1;
    public int[] square;
    public boolean whiteToMove;
    public int colourToMove;
    public int opponentColour;
    public int colourToMoveIndex;
    public boolean lastMadeMoveIsCapture;
    public Move lastMadeMove;
    public long currentGameState;
    public int plyCount;
    public int fiftyMoveCounter;
    public int[] kingSquare;
    public PieceList[] rooks;
    public PieceList[] bishops;
    public PieceList[] queens;
    public PieceList[] knights;
    public PieceList[] pawns;
    PieceList[] allPieceLists;
    static final long whiteCastleKingsideMask = 65533L;
    static final long whiteCastleQueensideMask = 65534L;
    static final long blackCastleKingsideMask = 65527L;
    static final long blackCastleQueensideMask = 65531L;
    static final long whiteCastleMask = 65532L;
    static final long blackCastleMask = 65523L;

    PieceList getPieceList(int pieceType, int colourIndex) {
        return this.allPieceLists[colourIndex * 8 + pieceType];
    }

    public void makeMove(Move move) {
        this.makeMove(move, false);
    }

    public void makeMove(Move move, boolean inSearch) {
        long originalCastleState;
        long newCastleState = originalCastleState = this.currentGameState & 0xFL;
        this.currentGameState = 0L;
        int opponentColourIndex = 1 - this.colourToMoveIndex;
        int moveFrom = move.getStartSquare();
        int moveTo = move.getTargetSquare();
        int capturedPieceType = Piece.pieceType(this.square[moveTo]);
        int movePiece = this.square[moveFrom];
        int movePieceType = Piece.pieceType(movePiece);
        int moveFlag = move.getMoveFlag();
        boolean isPromotion = move.isPromotion();
        boolean isEnPassant = moveFlag == 1;
        this.currentGameState |= (long)(capturedPieceType << 8);
        if (capturedPieceType != 0 && !isEnPassant) {
            this.getPieceList(capturedPieceType, opponentColourIndex).removePieceAtSquare(moveTo);
        }
        if (movePieceType == 1) {
            this.kingSquare[this.colourToMoveIndex] = moveTo;
            newCastleState &= this.whiteToMove ? 65532L : 65523L;
        } else {
            this.getPieceList(movePieceType, this.colourToMoveIndex).movePiece(moveFrom, moveTo);
        }
        int pieceOnTargetSquare = movePiece;
        if (isPromotion) {
            int promoteType = 0;
            switch (moveFlag) {
                case 3: {
                    promoteType = 7;
                    this.queens[this.colourToMoveIndex].addPieceAtSquare(moveTo);
                    break;
                }
                case 5: {
                    promoteType = 6;
                    this.rooks[this.colourToMoveIndex].addPieceAtSquare(moveTo);
                    break;
                }
                case 6: {
                    promoteType = 5;
                    this.bishops[this.colourToMoveIndex].addPieceAtSquare(moveTo);
                    break;
                }
                case 4: {
                    promoteType = 3;
                    this.knights[this.colourToMoveIndex].addPieceAtSquare(moveTo);
                }
            }
            pieceOnTargetSquare = promoteType | this.colourToMove;
            this.pawns[this.colourToMoveIndex].removePieceAtSquare(moveTo);
        } else {
            switch (moveFlag) {
                case 1: {
                    int epPawnSquare = moveTo + (this.colourToMove == 8 ? -8 : 8);
                    this.currentGameState |= (long)(this.square[epPawnSquare] << 8);
                    this.square[epPawnSquare] = 0;
                    this.pawns[opponentColourIndex].removePieceAtSquare(epPawnSquare);
                    break;
                }
                case 2: {
                    boolean kingside = moveTo == 1 || moveTo == 57;
                    int castlingRookFromIndex = kingside ? moveTo - 1 : moveTo + 2;
                    int castlingRookToIndex = kingside ? moveTo + 1 : moveTo - 1;
                    this.square[castlingRookFromIndex] = 0;
                    this.square[castlingRookToIndex] = 6 | this.colourToMove;
                    this.rooks[this.colourToMoveIndex].movePiece(castlingRookFromIndex, castlingRookToIndex);
                }
            }
        }
        this.square[moveTo] = pieceOnTargetSquare;
        this.square[moveFrom] = 0;
        if (moveFlag == 7) {
            int file = BoardRepresentation.fileIndex(moveFrom) + 1;
            this.currentGameState |= (long)(file << 4);
        }
        if (originalCastleState != 0L) {
            if (moveTo == 7 || moveFrom == 7) {
                newCastleState &= 0xFFFDL;
            } else if (moveTo == 0 || moveFrom == 0) {
                newCastleState &= 0xFFFEL;
            }
            if (moveTo == 63 || moveFrom == 63) {
                newCastleState &= 0xFFF7L;
            } else if (moveTo == 56 || moveFrom == 56) {
                newCastleState &= 0xFFFBL;
            }
        }
        this.currentGameState |= newCastleState;
        this.currentGameState |= (long)this.fiftyMoveCounter << 14;
        this.whiteToMove = !this.whiteToMove;
        this.colourToMove = this.whiteToMove ? 8 : 16;
        this.opponentColour = this.whiteToMove ? 16 : 8;
        this.colourToMoveIndex = 1 - this.colourToMoveIndex;
        ++this.plyCount;
        ++this.fiftyMoveCounter;
        if (!(inSearch || movePieceType != 2 && capturedPieceType == 0)) {
            this.fiftyMoveCounter = 0;
        }
        this.lastMadeMoveIsCapture = capturedPieceType != 0;
        this.lastMadeMove = move;
    }

    public void loadStartPosition() {
        this.loadPosition("rnbkqbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBKQBNR w KQkq - 0 1");
    }

    public void loadPosition(String fen) {
        this.initialize();
        FenUtility.LoadedPositionInfo loadedPosition = FenUtility.positionFromFen(fen);
        for (int squareIndex = 0; squareIndex < 64; ++squareIndex) {
            int pieceColourIndex;
            int piece;
            this.square[squareIndex] = piece = loadedPosition.squares[squareIndex];
            if (piece == 0) continue;
            int pieceType = Piece.pieceType(piece);
            int n = pieceColourIndex = Piece.isColour(piece, 8) ? 0 : 1;
            if (Piece.isSlidingPiece(piece)) {
                if (pieceType == 7) {
                    this.queens[pieceColourIndex].addPieceAtSquare(squareIndex);
                    continue;
                }
                if (pieceType == 6) {
                    this.rooks[pieceColourIndex].addPieceAtSquare(squareIndex);
                    continue;
                }
                if (pieceType != 5) continue;
                this.bishops[pieceColourIndex].addPieceAtSquare(squareIndex);
                continue;
            }
            if (pieceType == 3) {
                this.knights[pieceColourIndex].addPieceAtSquare(squareIndex);
                continue;
            }
            if (pieceType == 2) {
                this.pawns[pieceColourIndex].addPieceAtSquare(squareIndex);
                continue;
            }
            if (pieceType != 1) continue;
            this.kingSquare[pieceColourIndex] = squareIndex;
        }
        this.whiteToMove = loadedPosition.whiteToMove;
        this.colourToMove = this.whiteToMove ? 8 : 16;
        this.opponentColour = this.whiteToMove ? 16 : 8;
        this.colourToMoveIndex = this.whiteToMove ? 0 : 1;
        int whiteCastle = (loadedPosition.whiteCastleKingside ? 2 : 0) | (loadedPosition.whiteCastleQueenside ? 1 : 0);
        int blackCastle = (loadedPosition.blackCastleKingside ? 8 : 0) | (loadedPosition.blackCastleQueenside ? 4 : 0);
        int epState = loadedPosition.epFile << 4;
        int initialGameState = whiteCastle | blackCastle | epState;
        this.currentGameState = initialGameState;
        this.plyCount = loadedPosition.plyCount;
    }

    void initialize() {
        this.square = new int[64];
        this.kingSquare = new int[2];
        this.lastMadeMove = null;
        this.plyCount = 0;
        this.fiftyMoveCounter = 0;
        this.knights = new PieceList[]{new PieceList(10), new PieceList(10)};
        this.pawns = new PieceList[]{new PieceList(8), new PieceList(8)};
        this.rooks = new PieceList[]{new PieceList(10), new PieceList(10)};
        this.bishops = new PieceList[]{new PieceList(10), new PieceList(10)};
        this.queens = new PieceList[]{new PieceList(9), new PieceList(9)};
        PieceList emptyList = new PieceList(0);
        this.allPieceLists = new PieceList[]{emptyList, emptyList, this.pawns[0], this.knights[0], emptyList, this.bishops[0], this.rooks[0], this.queens[0], emptyList, emptyList, this.pawns[1], this.knights[1], emptyList, this.bishops[1], this.rooks[1], this.queens[1]};
    }
}

