/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.util.chess;

import flash.minechess.util.chess.BoardRepresentation;

public class Move {
    final int moveValue;
    static final int startSquareMask = 63;
    static final int targetSquareMask = 4032;
    static final int flagMask = 61440;

    public Move(int moveValue) {
        this.moveValue = moveValue;
    }

    public Move(int startSquare, int targetSquare) {
        this.moveValue = startSquare | targetSquare << 6;
    }

    public Move(int startSquare, int targetSquare, int flag) {
        this.moveValue = startSquare | targetSquare << 6 | flag << 12;
    }

    public int getStartSquare() {
        return this.moveValue & 0x3F;
    }

    public int getTargetSquare() {
        return (this.moveValue & 0xFC0) >> 6;
    }

    public boolean isPromotion() {
        int flag = this.getMoveFlag();
        return flag == 3 || flag == 5 || flag == 4 || flag == 6;
    }

    public int getMoveFlag() {
        return this.moveValue >> 12;
    }

    public int getPromotionPieceType() {
        switch (this.getMoveFlag()) {
            case 5: {
                return 6;
            }
            case 4: {
                return 3;
            }
            case 6: {
                return 5;
            }
            case 3: {
                return 7;
            }
        }
        return 0;
    }

    public static Move getInvalidMove() {
        return new Move(0);
    }

    public static boolean isSameMove(Move a, Move b) {
        return a.moveValue == b.moveValue;
    }

    public int getValue() {
        return this.moveValue;
    }

    public boolean isInvalid() {
        return this.moveValue == 0;
    }

    public String getName() {
        return BoardRepresentation.squareNameFromIndex(this.getStartSquare()) + "-" + BoardRepresentation.squareNameFromIndex(this.getTargetSquare());
    }

    public static final class Flag {
        public static final int None = 0;
        public static final int EnPassantCapture = 1;
        public static final int Castling = 2;
        public static final int PromoteToQueen = 3;
        public static final int PromoteToKnight = 4;
        public static final int PromoteToRook = 5;
        public static final int PromoteToBishop = 6;
        public static final int PawnTwoForward = 7;
    }
}

