/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld;

import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.events.LeafHandler;
import epicsquid.mysticalworld.events.MaskHandler;
import epicsquid.mysticalworld.events.global.GrassHandler;
import epicsquid.mysticalworld.events.mappings.Remaps;
import epicsquid.mysticalworld.gen.LootTableGenerator;
import epicsquid.mysticalworld.init.ModBlocks;
import epicsquid.mysticalworld.init.ModEffects;
import epicsquid.mysticalworld.init.ModEntities;
import epicsquid.mysticalworld.init.ModFeatures;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.init.ModLang;
import epicsquid.mysticalworld.init.ModModifiers;
import epicsquid.mysticalworld.init.ModRecipes;
import epicsquid.mysticalworld.init.ModSounds;
import epicsquid.mysticalworld.init.ModTags;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import epicsquid.mysticalworld.setup.ClientInit;
import epicsquid.mysticalworld.setup.CommonSetup;
import net.minecraft.block.Block;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import noobanidus.libs.repack_mysticalworld.noobutil.data.RecipeGenerator;
import noobanidus.libs.repack_mysticalworld.noobutil.modifiers.PlayerModifierRegistry;
import noobanidus.libs.repack_mysticalworld.noobutil.registrate.CustomRegistrate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mysticalworld")
public class MysticalWorld {
    public static PlantType STONE_PLANT;
    public static final Logger LOG;
    public static final String MODID = "mysticalworld";
    public static CustomRegistrate REGISTRATE;
    public static RecipeGenerator RECIPES;
    public static final ItemGroup ITEM_GROUP;

    public MysticalWorld() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigManager.COMMON_CONFIG);
        ConfigManager.loadConfig(ConfigManager.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("mysticalworld-common.toml"));
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::onDataGen);
        REGISTRATE = CustomRegistrate.create(MODID);
        REGISTRATE.itemGroup(NonNullSupplier.of(() -> ITEM_GROUP));
        ModBlocks.load();
        ModItems.load();
        ModEntities.load();
        ModRecipes.load();
        ModModifiers.load();
        ModSounds.load();
        ModEffects.load();
        ModLang.load();
        ModTags.load();
        ModFeatures.load();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientInit::init);
        modBus.addListener(CommonSetup::init);
        modBus.addListener(CommonSetup::loadComplete);
        modBus.addGenericListener(GlobalLootModifierSerializer.class, GrassHandler::registerModifiers);
        MinecraftForge.EVENT_BUS.addListener(CommonSetup::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(CommonSetup::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(LeafHandler::onBlockDrops);
        MinecraftForge.EVENT_BUS.addListener(MaskHandler::onAttackEntity);
        MinecraftForge.EVENT_BUS.addGenericListener(Block.class, Remaps::remapBlockEvent);
        MinecraftForge.EVENT_BUS.addGenericListener(Item.class, Remaps::remapItemEvent);
        MinecraftForge.EVENT_BUS.addGenericListener(EntityType.class, Remaps::remapEntityEvent);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ModFeatures::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(ModFeatures::onWorldLoad);
        CommonSetup.registerListeners();
        modBus.addListener(ConfigManager::configReload);
        PlayerModifierRegistry.addModifier(ModModifiers.SERENDIPITY);
        PlayerModifierRegistry.addModifier(ModModifiers.BLESSED);
        PlayerModifierRegistry.addModifier(ModModifiers.SMITE);
    }

    public void onDataGen(GatherDataEvent event) {
        if (event.includeServer()) {
            event.getGenerator().func_200390_a((IDataProvider)new LootTableGenerator(event.getGenerator()));
        }
    }

    static {
        LOG = LogManager.getLogger();
        RECIPES = new RecipeGenerator(MODID);
        ITEM_GROUP = new ItemGroup(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModBlocks.AMETHYST_BLOCK.get());
            }
        };
    }
}

