/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import noobanidus.libs.repack_mysticalworld.noobutil.block.BaseBlocks;
import noobanidus.libs.repack_mysticalworld.noobutil.util.VoxelUtil;

public class OakAppleBlock
extends BaseBlocks.CropsBlock {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape[] south_shapes = new VoxelShape[]{Block.func_208617_a((double)7.0, (double)7.0, (double)15.0, (double)9.0, (double)9.0, (double)16.0), Block.func_208617_a((double)7.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0, (double)16.0), Block.func_208617_a((double)6.5, (double)6.5, (double)14.0, (double)9.5, (double)9.5, (double)16.0), Block.func_208617_a((double)6.5, (double)6.5, (double)13.0, (double)9.5, (double)9.5, (double)16.0)};
    private static final VoxelShape[] north_shapes = new VoxelShape[]{VoxelUtil.rotateHorizontal(south_shapes[0], Direction.SOUTH), VoxelUtil.rotateHorizontal(south_shapes[1], Direction.SOUTH), VoxelUtil.rotateHorizontal(south_shapes[2], Direction.SOUTH), VoxelUtil.rotateHorizontal(south_shapes[3], Direction.SOUTH)};
    private static final VoxelShape[] west_shapes = new VoxelShape[]{VoxelUtil.rotateHorizontal(south_shapes[0], Direction.EAST), VoxelUtil.rotateHorizontal(south_shapes[1], Direction.EAST), VoxelUtil.rotateHorizontal(south_shapes[2], Direction.EAST), VoxelUtil.rotateHorizontal(south_shapes[3], Direction.EAST)};
    private static final VoxelShape[] east_shapes = new VoxelShape[]{VoxelUtil.rotateHorizontal(south_shapes[0], Direction.WEST), VoxelUtil.rotateHorizontal(south_shapes[1], Direction.WEST), VoxelUtil.rotateHorizontal(south_shapes[2], Direction.WEST), VoxelUtil.rotateHorizontal(south_shapes[3], Direction.WEST)};

    public OakAppleBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public IntegerProperty func_185524_e() {
        return AGE;
    }

    public int func_185526_g() {
        return 3;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!this.canBlockStay((World)worldIn, pos, state)) {
            worldIn.func_175655_b(pos, true);
        } else {
            int i = (Integer)state.func_177229_b((Property)AGE);
            if (i < 3 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)worldIn.func_180495_p(pos));
            }
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, BlockState state) {
        BlockState iblockstate = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((Property)FACING)));
        Block block = iblockstate.func_177230_c();
        return block == Blocks.field_196617_K || block == Blocks.field_196626_Q || block == Blocks.field_196623_P || block == Blocks.field_196639_V;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext context) {
        int i = (Integer)state.func_177229_b((Property)AGE);
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case SOUTH: {
                return south_shapes[i];
            }
            default: {
                return north_shapes[i];
            }
            case WEST: {
                return west_shapes[i];
            }
            case EAST: 
        }
        return east_shapes[i];
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return this.func_185499_a(state, mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected boolean func_200014_a_(BlockState p_200014_1_, IBlockReader p_200014_2_, BlockPos p_200014_3_) {
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canBlockStay(worldIn, pos, state) && !worldIn.field_72995_K) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)AGE) < 3;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)AGE) + 1)), 3);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, AGE});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction enumfacing = Direction.func_176733_a((double)placer.field_70177_z);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)enumfacing), 2);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196000_l();
        if (!facing.func_176740_k().func_176722_c()) {
            facing = Direction.NORTH;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing.func_176734_d())).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0));
    }
}

