/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import epicsquid.mysticalworld.MWTags;
import epicsquid.mysticalworld.config.AbstractConfig;
import epicsquid.mysticalworld.config.ArmorConfig;
import epicsquid.mysticalworld.config.HatConfig;
import epicsquid.mysticalworld.config.HellSproutConfig;
import epicsquid.mysticalworld.config.MobConfig;
import epicsquid.mysticalworld.config.OreConfig;
import epicsquid.mysticalworld.config.SilkwormConfig;
import epicsquid.mysticalworld.config.StonepetalConfig;
import epicsquid.mysticalworld.config.StructureConfig;
import epicsquid.mysticalworld.config.TreeConfig;
import epicsquid.mysticalworld.init.ConfiguredStructures;
import epicsquid.mysticalworld.init.ModBlocks;
import epicsquid.mysticalworld.init.ModFeatures;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import noobanidus.libs.repack_mysticalworld.noobutil.config.IArmorConfig;

public class ConfigManager {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static List<OreConfig> ORE_CONFIG;
    public static MobConfig DEER_CONFIG;
    public static MobConfig SPROUT_CONFIG;
    public static HellSproutConfig HELL_SPROUT_CONFIG;
    public static MobConfig BEETLE_CONFIG;
    public static MobConfig SILVER_FOX_CONFIG;
    public static MobConfig FROG_CONFIG;
    public static MobConfig ENDERMINI_CONFIG;
    public static MobConfig LAVA_CAT_CONFIG;
    public static MobConfig OWL_CONFIG;
    public static SilkwormConfig SILKWORM_CONFIG;
    public static HatConfig HAT_CONFIG;
    public static TreeConfig DEAD_TREE_CONFIG;
    public static StonepetalConfig STONEPETAL_CONFIG;
    public static StructureConfig HUT_CONFIG;
    public static StructureConfig BARROW_CONFIG;
    public static List<AbstractConfig> CONFIGS;
    public static Map<String, ArmorConfig> ARMOR_CONFIGS;

    public static IArmorConfig getArmorConfig(String name) {
        return ARMOR_CONFIGS.get(name);
    }

    private static void registerOreGeneration() {
        List<RegistryKey<World>> defaultDimensions = Collections.singletonList(World.field_234918_g_);
        ORE_CONFIG.add(new OreConfig("Copper", 8, 32, 76, 12, defaultDimensions, () -> ModBlocks.COPPER_ORE));
        ORE_CONFIG.add(new OreConfig("Tin", 8, 24, 64, 8, defaultDimensions, () -> ModBlocks.TIN_ORE));
        ORE_CONFIG.add(new OreConfig("Silver", 4, 0, 24, 8, defaultDimensions, () -> ModBlocks.SILVER_ORE));
        ORE_CONFIG.add(new OreConfig("Lead", 4, 8, 32, 8, defaultDimensions, () -> ModBlocks.LEAD_ORE));
        ORE_CONFIG.add(new OreConfig("Quicksilver", 3, 0, 16, 4, defaultDimensions, () -> ModBlocks.QUICKSILVER_ORE));
        ORE_CONFIG.add(new OreConfig("Amethyst", 4, 0, 24, 3, defaultDimensions, () -> ModBlocks.AMETHYST_ORE));
        ORE_CONFIG.add(new OreConfig("Quartz", 13, 24, 76, 4, defaultDimensions, () -> ModBlocks.GRANITE_QUARTZ_ORE, (RuleTest)new TagMatchRuleTest(MWTags.Blocks.BASE_STONE_GRANITE)));
        ORE_CONFIG.forEach(ore -> ore.apply(COMMON_BUILDER));
    }

    private static void registerMobConfigs() {
        DEER_CONFIG = new MobConfig("Deer", 6, 2, 4, Arrays.asList("forest", "icy", "taiga", "plains"));
        SPROUT_CONFIG = new MobConfig("Sprout", 2, 2, 4, Arrays.asList("jungle", "river", "forest", "beach"));
        HELL_SPROUT_CONFIG = new HellSproutConfig("Hell Sprout", 2, 1, 1, Collections.singletonList("nether"), 100);
        SILVER_FOX_CONFIG = new MobConfig("Silver Fox", 4, 1, 3, Arrays.asList("forest", "icy", "taiga"));
        BEETLE_CONFIG = new MobConfig("Beetle", 5, 2, 4, Arrays.asList("swamp", "jungle", "forest", "plains"));
        FROG_CONFIG = new MobConfig("Frog", 6, 2, 4, Arrays.asList("swamp", "jungle", "beach", "river"));
        ENDERMINI_CONFIG = new MobConfig("Endermini", 2, 1, 2, Collections.singletonList("end"), BiomeDictionary.Type.END);
        OWL_CONFIG = new MobConfig("Owl", 9, 1, 3, Arrays.asList("taiga", "extreme_hills", "forest", "icy"));
        LAVA_CAT_CONFIG = new MobConfig("Lava Cat", 2, 1, 1, Collections.singletonList("nether"), BiomeDictionary.Type.NETHER);
        SILKWORM_CONFIG = new SilkwormConfig(true, 65, 1, 68);
        HAT_CONFIG = new HatConfig();
        DEER_CONFIG.apply(COMMON_BUILDER);
        SPROUT_CONFIG.apply(COMMON_BUILDER);
        HELL_SPROUT_CONFIG.apply(COMMON_BUILDER);
        SILVER_FOX_CONFIG.apply(COMMON_BUILDER);
        BEETLE_CONFIG.apply(COMMON_BUILDER);
        FROG_CONFIG.apply(COMMON_BUILDER);
        ENDERMINI_CONFIG.apply(COMMON_BUILDER);
        OWL_CONFIG.apply(COMMON_BUILDER);
        LAVA_CAT_CONFIG.apply(COMMON_BUILDER);
        SILKWORM_CONFIG.apply(COMMON_BUILDER);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static void configReload(ModConfig.ModConfigEvent event) {
        CONFIGS.forEach(AbstractConfig::reset);
    }

    static {
        ORE_CONFIG = new ArrayList<OreConfig>();
        CONFIGS = new ArrayList<AbstractConfig>();
        ARMOR_CONFIGS = new HashMap<String, ArmorConfig>();
        COMMON_BUILDER.comment("Ore Generation").push("oregen");
        ConfigManager.registerOreGeneration();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Mob Spawn Configuration").push("mob_spawns");
        ConfigManager.registerMobConfigs();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Hat Configuration").push("hat_config");
        HAT_CONFIG.apply(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Armor Configuration").push("armor_config");
        ARMOR_CONFIGS.put("amethyst", new ArmorConfig("amethyst", 3, 6, 8, 3, 2.0f));
        ARMOR_CONFIGS.put("copper", new ArmorConfig("copper", 2, 5, 6, 2, 0.0f));
        ARMOR_CONFIGS.put("lead", new ArmorConfig("lead", 2, 5, 6, 2, 1.0f));
        ARMOR_CONFIGS.put("quicksilver", new ArmorConfig("quicksilver", 1, 3, 5, 2, 0.0f));
        ARMOR_CONFIGS.put("silver", new ArmorConfig("silver", 1, 3, 5, 2, 0.0f));
        ARMOR_CONFIGS.put("tin", new ArmorConfig("tin", 1, 4, 5, 2, 0.0f));
        ARMOR_CONFIGS.put("carapace", new ArmorConfig("carapace", 3, 0, 0, 0, 1.0f));
        ARMOR_CONFIGS.put("antler", new ArmorConfig("antler", 3, 0, 0, 0, 1.0f));
        ARMOR_CONFIGS.values().forEach(o -> o.apply(COMMON_BUILDER));
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Feature Spawn Configuration").push("feature_spawns");
        DEAD_TREE_CONFIG = (TreeConfig)new TreeConfig(0.04, Arrays.asList(BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.WASTELAND), Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END)).setFeature(() -> ModFeatures.CHARRED_TREE);
        DEAD_TREE_CONFIG.apply(COMMON_BUILDER);
        STONEPETAL_CONFIG = (StonepetalConfig)new StonepetalConfig(1, 7, Arrays.asList(BiomeDictionary.Type.MOUNTAIN), Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END)).setSupplierFeature(() -> ModFeatures.STONEPETAL_PATCH);
        STONEPETAL_CONFIG.apply(COMMON_BUILDER);
        HUT_CONFIG = (StructureConfig)new StructureConfig("hut", Arrays.asList(BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS), Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END)).setStructure(() -> ConfiguredStructures.CONFIGURED_HUT);
        HUT_CONFIG.apply(COMMON_BUILDER);
        BARROW_CONFIG = (StructureConfig)new StructureConfig("barrow", Arrays.asList(BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS), Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END)).setStructure(() -> ConfiguredStructures.CONFIGURED_BARROW);
        BARROW_CONFIG.apply(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

