/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import epicsquid.mysticalworld.config.AbstractConfig;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class FeatureConfig<T extends FeatureConfig>
extends AbstractConfig {
    protected List<BiomeDictionary.Type> biomes;
    protected List<BiomeDictionary.Type> biomeRestrictions;
    protected ForgeConfigSpec.ConfigValue<String> configBiomes;
    protected ForgeConfigSpec.ConfigValue<String> configBiomeRestrictions;
    protected Supplier<ConfiguredFeature<?, ?>> feature = null;
    protected Supplier<Supplier<ConfiguredFeature<?, ?>>> supplierFeature = null;
    protected Supplier<StructureFeature<?, ?>> structure = null;
    private Set<BiomeDictionary.Type> storedBiomes = null;
    private Set<BiomeDictionary.Type> storedRestrictions = null;

    public FeatureConfig(List<BiomeDictionary.Type> biomeTypes, List<BiomeDictionary.Type> biomeRestrictions) {
        this.biomes = biomeTypes;
        this.biomeRestrictions = biomeRestrictions;
    }

    public T setFeature(ConfiguredFeature<?, ?> feature) {
        return this.setFeature(() -> feature);
    }

    public T setFeature(Supplier<ConfiguredFeature<?, ?>> feature) {
        this.feature = feature;
        return (T)this;
    }

    public T setSupplierFeature(Supplier<Supplier<ConfiguredFeature<?, ?>>> feature) {
        this.supplierFeature = feature;
        return (T)this;
    }

    public T setStructure(StructureFeature<?, ?> structure) {
        return this.setStructure(() -> structure);
    }

    public T setStructure(Supplier<StructureFeature<?, ?>> structure) {
        this.structure = structure;
        return (T)this;
    }

    @Nullable
    public Supplier<ConfiguredFeature<?, ?>> getFeature() {
        if (this.supplierFeature != null) {
            return this.supplierFeature.get();
        }
        return this.feature;
    }

    @Nullable
    public Supplier<StructureFeature<?, ?>> getStructure() {
        return this.structure;
    }

    public boolean isFeature() {
        return true;
    }

    public abstract boolean shouldSpawn();

    public abstract GenerationStage.Decoration getStage();

    public Set<BiomeDictionary.Type> getBiomes() {
        if (this.storedBiomes == null) {
            this.storedBiomes = Stream.of(((String)this.configBiomes.get()).split(",")).map(o -> BiomeDictionary.Type.getType((String)o, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toSet());
        }
        return this.storedBiomes;
    }

    public Set<BiomeDictionary.Type> getBiomeRestrictions() {
        if (this.storedRestrictions == null) {
            this.storedRestrictions = Stream.of(((String)this.configBiomeRestrictions.get()).split(",")).map(o -> BiomeDictionary.Type.getType((String)o, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toSet());
        }
        return this.storedRestrictions;
    }

    @Override
    public abstract void apply(ForgeConfigSpec.Builder var1);

    @Override
    public void reset() {
        this.storedBiomes = null;
        this.storedRestrictions = null;
    }
}

