/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import epicsquid.mysticalworld.config.MobConfig;
import java.util.List;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class HellSproutConfig
extends MobConfig {
    protected int growChance;
    private int cachedGrow = -9999;
    protected ForgeConfigSpec.IntValue configGrowChance;

    public HellSproutConfig(String name, int chance, int min, int max, List<String> biomes, int growChance) {
        super(name, chance, min, max, biomes, BiomeDictionary.Type.NETHER);
        this.growChance = growChance;
    }

    public int getGrowChance() {
        if (this.cachedGrow == -9999) {
            this.cachedGrow = (Integer)this.configGrowChance.get();
        }
        return this.cachedGrow;
    }

    @Override
    protected void doApply(ForgeConfigSpec.Builder builder) {
        super.doApply(builder);
        this.configGrowChance = builder.comment("how often a hell sprout should attempt to plant nether wart (1 in X, 0 for never)").defineInRange("chance", this.growChance, 0, Integer.MAX_VALUE);
    }

    @Override
    public void reset() {
        super.reset();
        this.cachedGrow = -9999;
    }
}

