/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import epicsquid.mysticalworld.config.FeatureConfig;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class StonepetalConfig
extends FeatureConfig<StonepetalConfig> {
    private final int repeats;
    private final int tries;
    private ForgeConfigSpec.IntValue configRepeats;
    private ForgeConfigSpec.IntValue configTries;
    private int cachedRepeats = -9999;
    private int cachedTries = -9999;

    public StonepetalConfig(int repeats, int tries, List<BiomeDictionary.Type> biomeTypes, List<BiomeDictionary.Type> biomeRestrictions) {
        super(biomeTypes, biomeRestrictions);
        this.tries = tries;
        this.repeats = repeats;
    }

    public int getRepeats() {
        if (this.cachedRepeats == -9999) {
            this.cachedRepeats = (Integer)this.configRepeats.get();
        }
        return this.cachedRepeats;
    }

    public int getTries() {
        if (this.cachedTries == -9999) {
            this.cachedTries = (Integer)this.configTries.get();
        }
        return this.cachedTries;
    }

    @Override
    public boolean shouldSpawn() {
        return this.getTries() != 0;
    }

    @Override
    public GenerationStage.Decoration getStage() {
        return GenerationStage.Decoration.VEGETAL_DECORATION;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment("Stonepetal Patch Generation").push("stone_petal");
        this.configTries = builder.comment("Number of tries per chunk to try placing stonepetals on stone (set to 0 to disable).").defineInRange("tries", this.tries, 0, 256);
        this.configRepeats = builder.comment("Number of times per chunk to repeat trying to place stonepetals on stone").defineInRange("repeats", this.repeats, 1, 256);
        StringJoiner sb = new StringJoiner(",");
        this.biomes.forEach(o -> sb.add(o.getName()));
        this.configBiomes = builder.comment("List of biome types to spawn (default [" + sb.toString() + "], pass empty list for every biome").define("biomes", (Object)sb.toString());
        StringJoiner sb2 = new StringJoiner(",");
        this.biomeRestrictions.forEach(biome -> sb2.add(biome.getName()));
        this.configBiomeRestrictions = builder.comment("Which biome types this tree shouldn't spawn in (default END, NETHER)").define("biomeRestrictions", (Object)sb2.toString());
        builder.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.cachedRepeats = -9999;
        this.cachedTries = -9999;
    }
}

