/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.config;

import epicsquid.mysticalworld.config.FeatureConfig;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class TreeConfig
extends FeatureConfig<TreeConfig> {
    private double chance;
    private ForgeConfigSpec.DoubleValue configChance;
    private double cachedChance = -9999.0;

    public TreeConfig(double chance, List<BiomeDictionary.Type> biomeTypes, List<BiomeDictionary.Type> biomeRestrictions) {
        super(biomeTypes, biomeRestrictions);
        this.chance = chance;
    }

    public double getChance() {
        if (this.cachedChance == -9999.0) {
            this.cachedChance = (Double)this.configChance.get();
        }
        return this.cachedChance;
    }

    @Override
    public boolean shouldSpawn() {
        return this.getChance() != 0.0;
    }

    @Override
    public GenerationStage.Decoration getStage() {
        return GenerationStage.Decoration.VEGETAL_DECORATION;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment("Charred Tree Generation").push("charred_tree");
        this.configChance = builder.comment("Number of charred trees per chunk (set to 0 to disable).").defineInRange("chance", this.chance, 0.0, 256.0);
        StringJoiner sb = new StringJoiner(",");
        this.biomes.forEach(o -> sb.add(o.getName()));
        this.configBiomes = builder.comment("List of biome types to spawn (default [" + sb.toString() + "], pass empty list for every biome").define("biomes", (Object)sb.toString());
        StringJoiner sb2 = new StringJoiner(",");
        this.biomeRestrictions.forEach(biome -> sb2.add(biome.getName()));
        this.configBiomeRestrictions = builder.comment("Which biome types this tree shouldn't spawn in (default END, NETHER)").define("biomeRestrictions", (Object)sb2.toString());
        builder.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.cachedChance = -9999.0;
    }
}

