/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity;

import epicsquid.mysticalworld.init.ModEntities;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class OwlEntity
extends TameableEntity
implements IFlyingAnimal {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/owl");
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;

    public OwlEntity(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 15, false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233822_e_, 0.55);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator pathnavigateflying = new FlyingPathNavigator((MobEntity)this, worldIn);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    public float func_213307_e(Pose pose) {
        return this.func_213302_cg() * 0.6f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.calculateFlapping();
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.flapSpeed = MathHelper.func_76131_a((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vector3d motion = this.func_213322_ci();
        if (!this.field_70122_E && motion.field_72448_b < 0.0) {
            this.func_213293_j(motion.field_72450_a, motion.field_72448_b * 0.6, motion.field_72449_c);
        }
        this.flap += this.flapping * 2.0f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_179558_bo;
    }

    public static boolean placement(EntityType<? extends AnimalEntity> p_223316_0_, IWorld worldIn, SpawnReason reason, BlockPos blockpos, Random p_223316_4_) {
        BlockState down = worldIn.func_180495_p(blockpos.func_177977_b());
        Block block = down.func_177230_c();
        return block instanceof LeavesBlock || block == Blocks.field_150349_c || block instanceof RotatedPillarBlock && down.func_185904_a() == Material.field_151575_d || block == Blocks.field_150350_a && worldIn.func_201696_r(blockpos) > 8;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Nonnull
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return (AgeableEntity)ModEntities.OWL.get().func_200721_a(ageable.field_70170_p);
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 3.0f);
    }

    @Nullable
    public SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected float func_191954_d(float p_191954_1_) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return p_191954_1_ + this.flapSpeed / 2.0f;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected float func_70647_i() {
        return OwlEntity.getPitch(this.field_70146_Z);
    }

    private static float getPitch(Random random) {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity)) {
            super.func_82167_n(entityIn);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }
}

