/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity;

import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.events.LeafHandler;
import epicsquid.mysticalworld.init.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class SilkwormEntity
extends AnimalEntity {
    public static ResourceLocation LOOT_TABLE = new ResourceLocation("mysticalworld", "entity/silkworm");
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(SilkwormEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEAVES_CONSUMED = EntityDataManager.func_187226_a(SilkwormEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int MAX_SIZE = 120;
    private ItemEntity leafTarget;
    private int lastTickPlayed = 0;

    public SilkwormEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 1;
    }

    public void setLeafTarget(ItemEntity leaf) {
        this.leafTarget = leaf;
    }

    public ItemEntity getLeafTarget() {
        return this.leafTarget;
    }

    @Nonnull
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return null;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.5, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 0.9, false, Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])LeafHandler.getLeafItems().toArray(new Item[0])))));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SilkwormEntity.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)0);
        this.field_70180_af.func_187214_a(LEAVES_CONSUMED, (Object)0);
    }

    public int getLeavesConsumed() {
        return (Integer)this.field_70180_af.func_187225_a(LEAVES_CONSUMED);
    }

    public void setLeavesConsumed(int amount) {
        this.field_70180_af.func_187227_b(LEAVES_CONSUMED, (Object)amount);
    }

    public void resetLeaves() {
        this.field_70180_af.func_187227_b(LEAVES_CONSUMED, (Object)0);
    }

    private boolean shouldPlaySound() {
        return this.field_70173_aa - this.lastTickPlayed > 8;
    }

    public void eatLeaves() {
        this.incLeaves();
        for (int i = 0; i < 1 + this.field_70146_Z.nextInt(3); ++i) {
            this.grow();
        }
        this.func_70691_i(1.0f);
        if (this.shouldPlaySound()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191253_dD, SoundCategory.NEUTRAL, 0.5f, 1.2f + this.field_70146_Z.nextFloat() * 0.02f);
            this.lastTickPlayed = this.field_70173_aa;
        }
    }

    private void incLeaves() {
        this.field_70180_af.func_187227_b(LEAVES_CONSUMED, (Object)(this.getLeavesConsumed() + 1));
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public void setSize(int size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size);
    }

    private void incSize() {
        if (!this.func_70631_g_()) {
            this.field_70180_af.func_187227_b(SIZE, (Object)(this.getSize() + 1));
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (LeafHandler.getLeafItems().contains(itemstack.func_77973_b())) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.eatLeaves();
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public float func_213307_e(Pose pose) {
        return 0.1f;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.15);
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            return SoundEvents.field_187535_aY;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187590_ba;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187536_aZ;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_187592_bb, 0.15f, 1.3f + (this.field_70170_p.field_73012_v.nextFloat() - 0.5f));
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    protected float func_70647_i() {
        return 1.3f + this.field_70146_Z.nextFloat() - 0.5f;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSize(compound.func_74762_e("Size"));
        this.setLeavesConsumed(compound.func_74762_e("Leaves"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Size", this.getSize());
        compound.func_74768_a("Leaves", this.getLeavesConsumed());
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        EffectInstance potioneffect = this.func_70660_b(Effects.field_76430_j);
        float f = potioneffect == null ? 0.0f : (float)(potioneffect.func_76458_c() + 1);
        int i = MathHelper.func_76123_f((float)((distance - 3.0f - f) * damageMultiplier));
        if (i > 0) {
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            int j = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int k = MathHelper.func_76128_c((double)(this.func_226278_cu_() - 0.2));
            int l = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(j, k, l));
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                SoundType soundtype = iblockstate.func_177230_c().getSoundType(iblockstate, (IWorldReader)this.field_70170_p, new BlockPos(j, k, l), (Entity)this);
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(ConfigManager.SILKWORM_CONFIG.getGrowthChance()) == 0) {
            this.grow();
        }
    }

    public void grow() {
        int size = this.getSize();
        if (size == 120) {
            this.setSize(0);
            if (this.func_70613_aW()) {
                int quantity = Math.max(1, Math.min(5, this.field_70146_Z.nextInt(Math.max(this.getLeavesConsumed() % 8, 1))));
                this.func_199702_a((IItemProvider)ModItems.SILK_COCOON.get(), quantity);
                this.resetLeaves();
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187665_Y, SoundCategory.NEUTRAL, 0.5f, 1.2f + this.field_70146_Z.nextFloat() - 0.5f);
            }
        } else {
            this.incSize();
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof SilkwormEntity) {
            SilkwormEntity other = (SilkwormEntity)entityIn;
            if (other.getSize() > this.getSize()) {
                return false;
            }
            boolean result = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.1474836E9f);
            if (result) {
                this.grow();
            }
            return result;
        }
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }
}

