/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity;

import epicsquid.mysticalworld.init.ModEntities;
import epicsquid.mysticalworld.init.ModSounds;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class SilverFoxEntity
extends TameableEntity {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(SilverFoxEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public SilverFoxEntity(EntityType<? extends SilverFoxEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70903_f(false);
        this.field_70728_aV = 5;
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return stack.func_77973_b() == Items.field_151076_bf;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.FOX_BARK.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.FOX_DEATH.get();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151076_bf}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, e -> e instanceof ChickenEntity || e instanceof RabbitEntity));
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.isAngry()) {
            return ModSounds.FOX_AGGRO.get();
        }
        return ModSounds.FOX_IDLE.get();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isAngry() && this.func_70608_bn()) {
            this.func_233686_v_(false);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isAngry()) {
            this.setAngry(false);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.func_70608_bn()) {
            this.func_233686_v_(false);
        }
        this.func_233687_w_(false);
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof ArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_184185_a(ModSounds.FOX_BITE.get(), 1.0f, 1.0f);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(10.0);
        }
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(5.0);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            boolean flag = this.func_152114_e((LivingEntity)player) || this.func_70909_n() || item == Items.field_151034_e && !this.func_70909_n();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            ActionResultType actionresulttype;
            if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                Food food;
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                if ((food = item.func_219967_s()) != null) {
                    this.func_70691_i(food.func_221466_a());
                    return ActionResultType.SUCCESS;
                }
            }
            if ((!(actionresulttype = super.func_230254_b_(player, hand)).func_226246_a_() || this.func_70631_g_()) && this.func_152114_e((LivingEntity)player)) {
                this.func_233687_w_(!this.func_233685_eM_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                return ActionResultType.SUCCESS;
            }
            return actionresulttype;
        }
        if (item == Items.field_151034_e) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            SilverFoxEntity entityfox;
            if (target instanceof SilverFoxEntity && (entityfox = (SilverFoxEntity)target).func_70909_n() && entityfox.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            return !(target instanceof AbstractHorseEntity) || !((AbstractHorseEntity)target).func_110248_bS();
        }
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.isAngry() && super.func_184652_a(player);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return (AgeableEntity)ModEntities.SILVER_FOX.get().func_200721_a(ageable.field_70170_p);
    }

    @Nonnull
    public ResourceLocation func_184647_J() {
        return new ResourceLocation("mysticalworld", "entities/silver_fox");
    }

    public static class SleepGoal
    extends Goal {
        private final SilverFoxEntity tameable;
        private boolean isSleeping;

        public SleepGoal(SilverFoxEntity entityIn) {
            this.tameable = entityIn;
            EnumSet mutexes = this.func_220686_i();
            mutexes.add(Goal.Flag.JUMP);
            this.func_220684_a(mutexes);
        }

        public boolean func_75250_a() {
            if (!this.tameable.func_70909_n()) {
                return false;
            }
            if (this.tameable.func_70090_H()) {
                return false;
            }
            if (!this.tameable.field_70122_E) {
                return false;
            }
            LivingEntity entitylivingbase = this.tameable.func_70902_q();
            if (entitylivingbase == null) {
                return true;
            }
            return !(this.tameable.func_70068_e((Entity)entitylivingbase) < 144.0 && entitylivingbase.func_70643_av() != null || !this.isSleeping);
        }

        public void func_75249_e() {
            this.tameable.func_70661_as().func_75499_g();
            this.tameable.func_233686_v_(true);
        }

        public void func_75251_c() {
            this.tameable.func_233686_v_(false);
        }

        public void setSleeping(boolean sleeping) {
            this.isSleeping = sleeping;
        }
    }
}

