/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.entity.ai;

import epicsquid.mysticalworld.config.ConfigManager;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;

public class HealTargetGoal
extends TargetGoal {
    private CreatureEntity attacker;
    private int attackTick;
    private double speedTowardsTarget;
    private boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;

    public HealTargetGoal(CreatureEntity attacker, double speedTowardsTarget) {
        super((MobEntity)attacker, false, false);
        this.attacker = attacker;
        this.speedTowardsTarget = speedTowardsTarget;
        this.longMemory = true;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity target = this.attacker.func_70638_az();
        if (target == null) {
            return false;
        }
        return target instanceof PlayerEntity;
    }

    public boolean func_75253_b() {
        LivingEntity target = this.attacker.func_70638_az();
        if (target == null) {
            return false;
        }
        if (target instanceof PlayerEntity) {
            this.path = this.attacker.func_70661_as().func_75494_a((Entity)target, 0);
            return this.path != null;
        }
        return false;
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
    }

    public void func_75251_c() {
        LivingEntity entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase instanceof PlayerEntity && (entitylivingbase.func_175149_v() || ((PlayerEntity)entitylivingbase).func_184812_l_())) {
            this.attacker.func_70624_b(null);
        }
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        LivingEntity entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase != null) {
            this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
            double d0 = this.attacker.func_70092_e(entitylivingbase.func_226277_ct_(), entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.func_226281_cx_());
            --this.delayCounter;
            this.targetX = entitylivingbase.func_226277_ct_();
            this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
            this.targetZ = entitylivingbase.func_226281_cx_();
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            this.checkAndHeal(entitylivingbase, d0);
        }
    }

    protected void checkAndHeal(LivingEntity enemy, double distToEnemySqr) {
        double d0 = 1.5;
        if (distToEnemySqr <= d0 && this.attackTick <= 0) {
            this.attackTick = 20;
            this.attacker.func_184609_a(Hand.MAIN_HAND);
            enemy.func_70691_i(ConfigManager.HAT_CONFIG.getAntlerHealing());
            enemy.func_195064_c(new EffectInstance(Effects.field_76428_l, ConfigManager.HAT_CONFIG.getAntlerRegenDuration(), ConfigManager.HAT_CONFIG.getAntlerRegenAmplifier(), false, false));
            this.attacker.func_70106_y();
        }
    }
}

