/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import epicsquid.mysticalworld.init.ModModifiers;
import epicsquid.mysticalworld.loot.Serendipity;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ApplyBonusModified
extends LootFunction {
    private static final Map<ResourceLocation, IFormulaDeserializer> field_215875_a = Maps.newHashMap();
    private final Enchantment enchantment;
    private final IFormula field_215877_d;

    private ApplyBonusModified(ILootCondition[] p_i51246_1_, Enchantment p_i51246_2_, IFormula p_i51246_3_) {
        super(p_i51246_1_);
        this.enchantment = p_i51246_2_;
        this.field_215877_d = p_i51246_3_;
    }

    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237443_p_;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216289_i);
    }

    public ItemStack func_215859_a(ItemStack p_215859_1_, LootContext context) {
        ItemStack lvt_3_1_ = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (lvt_3_1_ != null) {
            Entity entity;
            int lvt_4_1_ = EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)lvt_3_1_);
            if (this.enchantment == Enchantments.field_185308_t && (entity = (Entity)context.func_216031_c(LootParameters.field_216281_a)) instanceof PlayerEntity) {
                double serendipity = ((PlayerEntity)entity).func_233637_b_(ModModifiers.SERENDIPITY.get());
                lvt_4_1_ += Serendipity.calculateAdditional(serendipity);
            }
            int lvt_5_1_ = this.field_215877_d.func_216204_a(context.func_216032_b(), p_215859_1_.func_190916_E(), lvt_4_1_);
            p_215859_1_.func_190920_e(lvt_5_1_);
        }
        return p_215859_1_;
    }

    public static LootFunction.Builder<?> binomialWithBonusCount(Enchantment p_215870_0_, float p_215870_1_, int p_215870_2_) {
        return ApplyBonusModified.func_215860_a(p_215864_3_ -> new ApplyBonusModified((ILootCondition[])p_215864_3_, p_215870_0_, new BinomialWithBonusCountFormula(p_215870_2_, p_215870_1_)));
    }

    public static LootFunction.Builder<?> oreDrops(Enchantment p_215869_0_) {
        return ApplyBonusModified.func_215860_a(p_215866_1_ -> new ApplyBonusModified((ILootCondition[])p_215866_1_, p_215869_0_, new OreDropsFormula()));
    }

    public static LootFunction.Builder<?> uniformBonusCount(Enchantment p_215871_0_) {
        return ApplyBonusModified.func_215860_a(p_215872_1_ -> new ApplyBonusModified((ILootCondition[])p_215872_1_, p_215871_0_, new UniformBonusCountFormula(1)));
    }

    public static LootFunction.Builder<?> uniformBonusCount(Enchantment p_215865_0_, int p_215865_1_) {
        return ApplyBonusModified.func_215860_a(p_215868_2_ -> new ApplyBonusModified((ILootCondition[])p_215868_2_, p_215865_0_, new UniformBonusCountFormula(p_215865_1_)));
    }

    static {
        field_215875_a.put(BinomialWithBonusCountFormula.field_216211_a, BinomialWithBonusCountFormula::func_216210_a);
        field_215875_a.put(OreDropsFormula.field_216206_a, OreDropsFormula::func_216205_a);
        field_215875_a.put(UniformBonusCountFormula.field_216208_a, UniformBonusCountFormula::func_216207_a);
    }

    static interface IFormula {
        public int func_216204_a(Random var1, int var2, int var3);

        public void func_216202_a(JsonObject var1, JsonSerializationContext var2);

        public ResourceLocation func_216203_a();
    }

    static interface IFormulaDeserializer {
        public IFormula deserialize(JsonObject var1, JsonDeserializationContext var2);
    }

    static final class BinomialWithBonusCountFormula
    implements IFormula {
        public static final ResourceLocation field_216211_a = new ResourceLocation("binomial_with_bonus_count");
        private final int extra;
        private final float probability;

        public BinomialWithBonusCountFormula(int p_i50983_1_, float p_i50983_2_) {
            this.extra = p_i50983_1_;
            this.probability = p_i50983_2_;
        }

        @Override
        public int func_216204_a(Random p_216204_1_, int p_216204_2_, int p_216204_3_) {
            for (int lvt_4_1_ = 0; lvt_4_1_ < p_216204_3_ + this.extra; ++lvt_4_1_) {
                if (!(p_216204_1_.nextFloat() < this.probability)) continue;
                ++p_216204_2_;
            }
            return p_216204_2_;
        }

        @Override
        public void func_216202_a(JsonObject p_216202_1_, JsonSerializationContext p_216202_2_) {
            p_216202_1_.addProperty("extra", (Number)this.extra);
            p_216202_1_.addProperty("probability", (Number)Float.valueOf(this.probability));
        }

        public static IFormula func_216210_a(JsonObject p_216210_0_, JsonDeserializationContext p_216210_1_) {
            int lvt_2_1_ = JSONUtils.func_151203_m((JsonObject)p_216210_0_, (String)"extra");
            float lvt_3_1_ = JSONUtils.func_151217_k((JsonObject)p_216210_0_, (String)"probability");
            return new BinomialWithBonusCountFormula(lvt_2_1_, lvt_3_1_);
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216211_a;
        }
    }

    static final class UniformBonusCountFormula
    implements IFormula {
        public static final ResourceLocation field_216208_a = new ResourceLocation("uniform_bonus_count");
        private final int bonusMultiplier;

        public UniformBonusCountFormula(int p_i50981_1_) {
            this.bonusMultiplier = p_i50981_1_;
        }

        @Override
        public int func_216204_a(Random p_216204_1_, int p_216204_2_, int p_216204_3_) {
            return p_216204_2_ + p_216204_1_.nextInt(this.bonusMultiplier * p_216204_3_ + 1);
        }

        @Override
        public void func_216202_a(JsonObject p_216202_1_, JsonSerializationContext p_216202_2_) {
            p_216202_1_.addProperty("bonusMultiplier", (Number)this.bonusMultiplier);
        }

        public static IFormula func_216207_a(JsonObject p_216207_0_, JsonDeserializationContext p_216207_1_) {
            int lvt_2_1_ = JSONUtils.func_151203_m((JsonObject)p_216207_0_, (String)"bonusMultiplier");
            return new UniformBonusCountFormula(lvt_2_1_);
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216208_a;
        }
    }

    static final class OreDropsFormula
    implements IFormula {
        public static final ResourceLocation field_216206_a = new ResourceLocation("ore_drops");

        private OreDropsFormula() {
        }

        @Override
        public int func_216204_a(Random p_216204_1_, int p_216204_2_, int p_216204_3_) {
            if (p_216204_3_ > 0) {
                int lvt_4_1_ = p_216204_1_.nextInt(p_216204_3_ + 2) - 1;
                if (lvt_4_1_ < 0) {
                    lvt_4_1_ = 0;
                }
                return p_216204_2_ * (lvt_4_1_ + 1);
            }
            return p_216204_2_;
        }

        @Override
        public void func_216202_a(JsonObject p_216202_1_, JsonSerializationContext p_216202_2_) {
        }

        public static IFormula func_216205_a(JsonObject p_216205_0_, JsonDeserializationContext p_216205_1_) {
            return new OreDropsFormula();
        }

        @Override
        public ResourceLocation func_216203_a() {
            return field_216206_a;
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<ApplyBonusModified> {
        public void serialize(JsonObject p_230424_1_, ApplyBonusModified p_230424_2_, JsonSerializationContext p_230424_3_) {
            super.func_230424_a_(p_230424_1_, (LootFunction)p_230424_2_, p_230424_3_);
            p_230424_1_.addProperty("enchantment", Registry.field_212628_q.func_177774_c((Object)p_230424_2_.enchantment).toString());
            p_230424_1_.addProperty("formula", p_230424_2_.field_215877_d.func_216203_a().toString());
            JsonObject lvt_4_1_ = new JsonObject();
            p_230424_2_.field_215877_d.func_216202_a(lvt_4_1_, p_230424_3_);
            if (lvt_4_1_.size() > 0) {
                p_230424_1_.add("parameters", (JsonElement)lvt_4_1_);
            }
        }

        public ApplyBonusModified deserialize(JsonObject p_186530_1_, JsonDeserializationContext p_186530_2_, ILootCondition[] p_186530_3_) {
            ResourceLocation lvt_4_1_ = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)p_186530_1_, (String)"enchantment"));
            Enchantment lvt_5_1_ = (Enchantment)Registry.field_212628_q.func_241873_b(lvt_4_1_).orElseThrow(() -> new JsonParseException("Invalid enchantment id: " + lvt_4_1_));
            ResourceLocation lvt_6_1_ = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)p_186530_1_, (String)"formula"));
            IFormulaDeserializer lvt_7_1_ = (IFormulaDeserializer)field_215875_a.get(lvt_6_1_);
            if (lvt_7_1_ == null) {
                throw new JsonParseException("Invalid formula id: " + lvt_6_1_);
            }
            IFormula lvt_8_2_ = p_186530_1_.has("parameters") ? lvt_7_1_.deserialize(JSONUtils.func_152754_s((JsonObject)p_186530_1_, (String)"parameters"), p_186530_2_) : lvt_7_1_.deserialize(new JsonObject(), p_186530_2_);
            return new ApplyBonusModified(p_186530_3_, lvt_5_1_, lvt_8_2_);
        }
    }
}

